#!/bin/bash

#---------------------------------------------------------------------------#
# Script for running benchmarks
#
# Original by V. Schuppan
#---------------------------------------------------------------------------#

TIMEOUT=600
MEMOUT=6144

# examples
selfpath=`dirname ${0}`
. ${selfpath}/config_examples.bash

#------------------------------------------------------------------------------#
# main
#

case "`hostname`" in
    hochgrat)
        TOPDIR=/home/schuppan/projects/trpuc
        RUN=/usr/local/src/run-1.4-mine/run
        PLTLMUP=${TOPDIR}/usr/src/pltl-mup/pltl-mup/pltlmup
        ;;
    *)
        echo "Error: host `hostname` not configured."
        exit 1
        ;;
esac;

for example in ${examples[@]}; do
    examplefile="${example}.pltl"
    logfile="${example}.pltlmup.log"
    rm -f ${logfile}

    cmd="${PLTLMUP}"
    cmd="${RUN} --time-limit=${TIMEOUT} --space-limit=${MEMOUT} --report-rate=0 ${cmd}"

    echo -n -e "${logfile}...\n"
    echo -n -e "${cmd}\n"
    echo -n -e "${cmd}\n" >${logfile}

    cat ${examplefile} | ${cmd} >>${logfile} 2>&1

    echo -n -e " done.\n"
done
