#!/bin/bash

#---------------------------------------------------------------------------#
# Script for running benchmarks
#
# Original by V. Schuppan
#---------------------------------------------------------------------------#

TIMEOUT=600
MEMOUT=6144

# examples
selfpath=`dirname ${0}`
. ${selfpath}/config_examples.bash

#------------------------------------------------------------------------------#
# main
#

case "`hostname`" in
    hochgrat)
        TOPDIR=/home/schuppan/projects/trpuc
        RUN=/usr/local/src/run-1.4-mine/run
        PROCMINE=${TOPDIR}/usr/src/procminenomus/inconanalysis
        ;;
    *)
        echo "Error: host `hostname` not configured."
        exit 1
        ;;
esac;

for example in ${examples[@]}; do
    examplefile="${example}.procmine"
    logfile="${example}.procminenomus.log"
    rm -f ${logfile}

    cmd="${PROCMINE} 2 0"
    cmd="${RUN} --time-limit=${TIMEOUT} --space-limit=${MEMOUT} --report-rate=0 ${cmd}"

    echo -n -e "${logfile}...\n"
    echo -n -e "${cmd}\n"
    echo -n -e "${cmd}\n" >${logfile}

    cp ${examplefile} constraints.pltl
    ulimitsoftstacklimit=`ulimit -S -s`
    ulimithardstacklimit=`ulimit -H -s`
    ulimit -S -s ${ulimithardstacklimit}
    ${cmd} >>${logfile} 2>&1
    ulimit -S -s ${ulimitsoftstacklimit}
    rm -f constraints.pltl
    if [ -f encoding.pltl ]; then mv encoding.pltl ${example}.nomus.encoding.procmine; fi
    if [ -f dk.pltl ]; then mv dk.pltl ${example}.nomus.dk.procmine; fi
    if [ -f unsatcore.pltl ]; then mv unsatcore.pltl ${example}.nomus.unsatcore.procmine; fi

    echo -n -e " done.\n"
done
