#!/bin/bash

#---------------------------------------------------------------------------#
# Script for running benchmarks
#
# Original by V. Schuppan
#---------------------------------------------------------------------------#

TIMEOUT=600
MEMOUT=6144

# examples and methods
selfpath=`dirname ${0}`
. ${selfpath}/config_examples.bash

TMPDIR=/tmp

#------------------------------------------------------------------------------#
# main
#

case "`hostname`" in
    hochgrat)
        TOPDIR=/home/schuppan/projects/trpuc
        RUN=/usr/local/src/run-1.4-mine/run
        TRP=${TOPDIR}/trpuc/REMOVE_FULL_SHARING/bin/trp++uc
        ;;
    *)
        echo "Error: host `hostname` not configured."
        exit 1
        ;;
esac;

for example in ${examples[@]}; do
    for meth in sizenonnf ; do
        nnfswitch=--no-nnf

        examplefile="${example}.trp"
        logfile="${example}.${meth}.log"
        rm -f ${logfile}
            
        cmd=
        case ${meth} in
	    sizenonnf)
                cmd="${TRP} -s BFS ${nnfswitch} --sharing=none -f ltl"
	        cmd="${RUN} --time-limit=${TIMEOUT} --space-limit=${MEMOUT} --report-rate=0 ${cmd}"
	        ;;
        esac;

        echo -n -e "${logfile}...\n"
        echo -n -e "${cmd}\n"
        echo -n -e "${cmd}\n" >${logfile}

	${cmd} "${examplefile}" >>${logfile} 2>&1

        killall -q -u `whoami` trp++uc
        
        echo -n -e " done.\n"
    done
done
