#!/bin/bash

#---------------------------------------------------------------------------#
# Script for running benchmarks
#
# Original by V. Schuppan
#---------------------------------------------------------------------------#

TIMEOUT=600
MEMOUT=6144

# examples
selfpath=`dirname ${0}`

#------------------------------------------------------------------------------#
# main
#

case "`hostname`" in
    hochgrat)
        TOPDIR=/home/schuppan/projects/trpuc
        RUN=/usr/local/src/run-1.4-mine/run
        TRP=${TOPDIR}/trpuc/REMOVE_FULL_SHARING/bin/trp++uc
        ;;
    *)
        echo "Error: host `hostname` not configured."
        exit 1
        ;;
esac;

for meth in none proof_aug2 proof_bfsloopitinitcg proof_bfsloopitinitce proof_bfsloopconclusion2e proof_noprunemain proof_nopruneloopits proof_all proof proofdeletion deletion proof_partitionedpropositions; do
    for sharing in none same; do
        examples=
        . ${selfpath}/config_examples.${meth}.${sharing}.bash
        for example in ${examples[@]}; do

            nnfswitch=
            (echo "${example}"|grep -q "^lift") && nnfswitch=--no-nnf

            makesharedswitch=
            (echo "${example}"|grep -q "^genbuf_c_l1\|^genbuf_c_l2") && makesharedswitch=--no-make-shared

            sharingswitch=
            if [ "${sharing}" == "none" ]; then
                sharingswitch="--sharing=none"
            fi

            examplefile="${example}.trp"
            logfile="${example}.${meth}.${sharing}.log"
            rm -f ${logfile}

            cmd=
            case ${meth} in
	        none)
                    cmd="${TRP} -s BFS ${makesharedswitch} -f ltl ${nnfswitch} ${sharingswitch}"
	            ;;
	        proof)
                    cmd="${TRP} -s BFS ${makesharedswitch} -f ltl ${nnfswitch} ${sharingswitch} -u"
                    rm -f ${examplefile}.simple.proof.{internal,snf,ltlc,ltl}
	            ;;
	        proofdeletion)
                    cmd="${TRP} -s BFS ${makesharedswitch} -f ltl ${nnfswitch} ${sharingswitch} -u -a proofdeletion"
                    rm -f ${examplefile}.simple.proofdeletion.{internal,snf,ltlc,ltl}
	            ;;
	        proof_aug2)
                    cmd="${TRP} -s BFS ${makesharedswitch} -f ltl ${nnfswitch} ${sharingswitch} -u --no-rgnoedge-aug2"
                    rm -f ${examplefile}.simple.proof.{internal,snf,ltlc,ltl}
	            ;;
	        proof_bfsloopitinitcg)
                    cmd="${TRP} -s BFS ${makesharedswitch} -f ltl ${nnfswitch} ${sharingswitch} -u --no-rgnoedge-bfsloopitinitcg"
                    rm -f ${examplefile}.simple.proof.{internal,snf,ltlc,ltl}
	            ;;
	        proof_bfsloopitinitce)
                    cmd="${TRP} -s BFS ${makesharedswitch} -f ltl ${nnfswitch} ${sharingswitch} -u --no-rgnoedge-bfsloopitinitce"
                    rm -f ${examplefile}.simple.proof.{internal,snf,ltlc,ltl}
	            ;;
	        proof_bfsloopconclusion2e)
                    cmd="${TRP} -s BFS ${makesharedswitch} -f ltl ${nnfswitch} ${sharingswitch} -u --no-rgnoedge-bfsloopconclusion2e"
                    rm -f ${examplefile}.simple.proof.{internal,snf,ltlc,ltl}
	            ;;
	        proof_noprunemain)
                    cmd="${TRP} -s BFS ${makesharedswitch} -f ltl ${nnfswitch} ${sharingswitch} -u --no-prune-main-fwd-reachable --no-prune-main-bwd-reachable"
                    rm -f ${examplefile}.simple.proof.{internal,snf,ltlc,ltl}
	            ;;
	        proof_nopruneloopits)
                    cmd="${TRP} -s BFS ${makesharedswitch} -f ltl ${nnfswitch} ${sharingswitch} -u --no-prune-failed-loop-search-its"
                    rm -f ${examplefile}.simple.proof.{internal,snf,ltlc,ltl}
	            ;;
	        proof_all)
                    cmd="${TRP} -s BFS ${makesharedswitch} -f ltl ${nnfswitch} ${sharingswitch} -u --no-rgnoedge-aug2 --no-rgnoedge-bfsloopitinitcg --no-rgnoedge-bfsloopitinitce --no-rgnoedge-bfsloopconclusion2e --no-prune-main-fwd-reachable --no-prune-main-bwd-reachable --no-prune-failed-loop-search-its"
                    rm -f ${examplefile}.simple.proof.{internal,snf,ltlc,ltl}
	            ;;
	        deletion)
                    cmd="${TRP} -s BFS ${makesharedswitch} -f ltl ${nnfswitch} ${sharingswitch} -u -a deletion"
                    rm -f ${examplefile}.simple.deletion.{internal,snf,ltlc,ltl}
	            ;;
                proof_partitionedpropositions)
                    cmd="${TRP} -s BFS ${makesharedswitch} -f ltl ${nnfswitch} ${sharingswitch} -u --partitioned-propositions-uc"
                    rm -f ${examplefile}.partitioned.proof.{internal,snf,ltlc,ltl}
	            ;;
            esac;
	    cmd="${RUN} --time-limit=${TIMEOUT} --space-limit=${MEMOUT} --report-rate=0 ${cmd}"

            echo -n -e "${logfile}...\n"
            echo -n -e "${cmd}\n"
            echo -n -e "${cmd}\n" >${logfile}

	    ${cmd} "${examplefile}" >>${logfile} 2>&1

            killall -q -u `whoami` trp++uc-v2.1-20140310

            case ${meth} in
                none)
                    ;;
                proof|\
                proofdeletion|\
                deletion)
                # add sharing
                if [ -f ${examplefile}.simple.${meth}.internal ]; then mv ${examplefile}.simple.${meth}.internal ${examplefile}.simple.${meth}.${sharing}.internal; fi
                if [ -f ${examplefile}.simple.${meth}.snf ]; then mv ${examplefile}.simple.${meth}.snf ${examplefile}.simple.${meth}.${sharing}.snf; fi
                if [ -f ${examplefile}.simple.${meth}.ltlc ]; then mv ${examplefile}.simple.${meth}.ltlc ${examplefile}.simple.${meth}.${sharing}.ltlc; fi
                if [ -f ${examplefile}.simple.${meth}.ltl ]; then mv ${examplefile}.simple.${meth}.ltl ${examplefile}.simple.${meth}.${sharing}.ltl; fi
                    ;;
	        proof_aug2|\
	        proof_bfsloopitinitcg|\
	        proof_bfsloopitinitce|\
	        proof_bfsloopconclusion2e|\
	        proof_noprunemain|\
	        proof_nopruneloopits|\
	        proof_all)
                # fix meth and add sharing
                if [ -f ${examplefile}.simple.proof.internal ]; then mv ${examplefile}.simple.proof.internal ${examplefile}.simple.${meth}.${sharing}.internal; fi
                if [ -f ${examplefile}.simple.proof.snf ]; then mv ${examplefile}.simple.proof.snf ${examplefile}.simple.${meth}.${sharing}.snf; fi
                if [ -f ${examplefile}.simple.proof.ltlc ]; then mv ${examplefile}.simple.proof.ltlc ${examplefile}.simple.${meth}.${sharing}.ltlc; fi
                if [ -f ${examplefile}.simple.proof.ltl ]; then mv ${examplefile}.simple.proof.ltl ${examplefile}.simple.${meth}.${sharing}.ltl; fi
                    ;;
                proof_partitionedpropositions)
                # add sharing
                if [ -f ${examplefile}.partitioned.proof.internal ]; then mv ${examplefile}.partitioned.proof.internal ${examplefile}.partitioned.proof.${sharing}.internal; fi
                if [ -f ${examplefile}.partitioned.proof.snf ]; then mv ${examplefile}.partitioned.proof.snf ${examplefile}.partitioned.proof.${sharing}.snf; fi
                if [ -f ${examplefile}.partitioned.proof.ltlc ]; then mv ${examplefile}.partitioned.proof.ltlc ${examplefile}.partitioned.proof.${sharing}.ltlc; fi
                if [ -f ${examplefile}.partitioned.proof.ltl ]; then mv ${examplefile}.partitioned.proof.ltl ${examplefile}.partitioned.proof.${sharing}.ltl; fi
                    ;;
            esac;

            echo -n -e " done.\n"
        done
    done
done
