#!/bin/bash

#---------------------------------------------------------------------------#
# Script for running benchmarks
#
# Original by V. Schuppan
#---------------------------------------------------------------------------#

TIMEOUT=600
MEMOUT=6144

# examples and methods
selfpath=`dirname ${0}`
. ${selfpath}/config_examples.bash

TMPDIR=/tmp

#------------------------------------------------------------------------------#
# main
#

case "`hostname`" in
    scheffauer)
        TOPDIR=/home/schuppan/projects/trpuc
        RUN=/usr/local/src/run-1.4-mine/run
        TRP=${TOPDIR}/trpuc/bin/trp++
        ;;
    *)
        echo "Error: host `hostname` not configured."
        exit 1
        ;;
esac;

for nnf in no yes; do
    for example in ${examples[@]}; do
        for meth in none simple positionsetsg positionsetss ; do
            if [ $nnf == "no" ]; then
                nnfstr=nonnf
                nnfswitch=--no-nnf
            else
                nnfstr=nnf
                nnfswitch=
            fi
            examplefile="${example}.trp"
            logfile="${example}.${meth}.${nnfstr}.log"
            rm -f ${logfile}
            
            cmd=
            case ${meth} in
	        none)
                    cmd="${TRP} -s BFS ${nnfswitch} -f ltl -u none"
	            cmd="${RUN} --time-limit=${TIMEOUT} --space-limit=${MEMOUT} --report-rate=0 ${cmd}"
	            ;;
	        simple)
                    cmd="${TRP} -s BFS ${nnfswitch} -f ltl -u simple"
	            cmd="${RUN} --time-limit=${TIMEOUT} --space-limit=${MEMOUT} --report-rate=0 ${cmd}"
                    rm -f ${examplefile}.simple.{internal,snf,ltlc,ltl}
	            ;;
	        positionsetsg)
                    cmd="${TRP} -s BFS ${nnfswitch} -f ltl -u positionsets"
	            cmd="${RUN} --time-limit=${TIMEOUT} --space-limit=${MEMOUT} --report-rate=0 ${cmd}"
                    rm -f ${examplefile}.positionsets.{internal,snf,ltlc,ltl}
	            ;;
	        positionsetss)
                    cmd="${TRP} -s BFS ${nnfswitch} -f ltl -u positionsets --Parikh-algorithm=Sawa"
	            cmd="${RUN} --time-limit=${TIMEOUT} --space-limit=${MEMOUT} --report-rate=0 ${cmd}"
                    rm -f ${examplefile}.positionsets.{internal,snf,ltlc,ltl}
	            ;;
            esac;
            
            echo -n -e "${logfile}...\n"
            echo -n -e "${cmd}\n"
            echo -n -e "${cmd}\n" >${logfile}
            
	    ${cmd} "${examplefile}" >>${logfile} 2>&1
            
            killall -q -u `whoami` trp++
            
            case ${meth} in
	        none)
	            ;;
	        simple)
                    if [ -f ${examplefile}.simple.internal ]; then mv ${examplefile}.simple.internal ${examplefile}.simple.${nnfstr}.internal; fi
                    if [ -f ${examplefile}.simple.snf ]; then mv ${examplefile}.simple.snf ${examplefile}.simple.${nnfstr}.snf; fi
                    if [ -f ${examplefile}.simple.ltlc ]; then mv ${examplefile}.simple.ltlc ${examplefile}.simple.${nnfstr}.ltlc; fi
                    if [ -f ${examplefile}.simple.ltl ]; then mv ${examplefile}.simple.ltl ${examplefile}.simple.${nnfstr}.ltl; fi
	            ;;
	        positionsetsg)
                    if [ -f ${examplefile}.positionsets.internal ]; then mv ${examplefile}.positionsets.internal ${examplefile}.positionsetsg.${nnfstr}.internal; fi
                    if [ -f ${examplefile}.positionsets.snf ]; then mv ${examplefile}.positionsets.snf ${examplefile}.positionsetsg.${nnfstr}.snf; fi
                    if [ -f ${examplefile}.positionsets.ltlc ]; then mv ${examplefile}.positionsets.ltlc ${examplefile}.positionsetsg.${nnfstr}.ltlc; fi
                    if [ -f ${examplefile}.positionsets.ltl ]; then mv ${examplefile}.positionsets.ltl ${examplefile}.positionsetsg.${nnfstr}.ltl; fi
	            ;;
	        positionsetss)
                    if [ -f ${examplefile}.positionsets.internal ]; then mv ${examplefile}.positionsets.internal ${examplefile}.positionsetss.${nnfstr}.internal; fi
                    if [ -f ${examplefile}.positionsets.snf ]; then mv ${examplefile}.positionsets.snf ${examplefile}.positionsetss.${nnfstr}.snf; fi
                    if [ -f ${examplefile}.positionsets.ltlc ]; then mv ${examplefile}.positionsets.ltlc ${examplefile}.positionsetss.${nnfstr}.ltlc; fi
                    if [ -f ${examplefile}.positionsets.ltl ]; then mv ${examplefile}.positionsets.ltl ${examplefile}.positionsetss.${nnfstr}.ltl; fi
	            ;;
            esac;

            echo -n -e " done.\n"
        done
    done
done
