#!/bin/bash

#------------------------------------------------------------------------------#
# Script for running benchmarks
#
# Original by V. Schuppan
#------------------------------------------------------------------------------#

TIMEOUT=600
MEMOUT=6144

# examples and methods
selfpath=`dirname ${0}`
. ${selfpath}/config_examples.bash

TMPDIR=/tmp

#------------------------------------------------------------------------------#
# main
#

case "`hostname`" in
    hochgrat)
        TOPDIR=/home/schuppan/projects/trpuc
        RUN=/usr/local/src/run-1.4-mine/run
        TRP=${TOPDIR}/trpuc/REMOVE_FULL_SHARING/bin/trp++uc
        ;;
    *)
        echo "Error: host `hostname` not configured."
        exit 1
        ;;
esac;

for example in ${examples[@]}; do
    for meth in none simple setsoftimepointsg setsoftimepointss ; do
        for sharing in none same; do

            nnfswitch=
            (echo "${example}"|grep -q "^lift") && nnfswitch=--no-nnf

            makesharedswitch=
            (echo "${example}"|grep -q "^genbuf_c_l1\|^genbuf_c_l2") && makesharedswitch=--no-make-shared

            sharingswitch=
            if [ "${sharing}" == "none" ]; then
                sharingswitch="--sharing=none"
            fi

            examplefile="${example}.trp"
            logfile="${example}.${meth}.${sharing}.log"
            rm -f ${logfile}

            cmd=
            case ${meth} in
	        none)
                    cmd="${TRP} -s BFS ${makesharedswitch} ${nnfswitch} ${sharingswitch} -f ltl"
	            cmd="${RUN} --time-limit=${TIMEOUT} --space-limit=${MEMOUT} --report-rate=0 ${cmd}"
	            ;;
	        simple)
                    cmd="${TRP} -s BFS ${makesharedswitch} ${nnfswitch} ${sharingswitch} -f ltl -u"
	            cmd="${RUN} --time-limit=${TIMEOUT} --space-limit=${MEMOUT} --report-rate=0 ${cmd}"
                    rm -f ${examplefile}.simple.{internal,snf,ltlc,ltl}
	            ;;
	        setsoftimepointsg)
                    cmd="${TRP} -s BFS ${makesharedswitch} ${nnfswitch} ${sharingswitch} -f ltl -u --sets-of-time-points-uc"
	            cmd="${RUN} --time-limit=${TIMEOUT} --space-limit=${MEMOUT} --report-rate=0 ${cmd}"
                    rm -f ${examplefile}.setsoftimepoints.{internal,snf,ltlc,ltl}
	            ;;
	        setsoftimepointss)
                    cmd="${TRP} -s BFS ${makesharedswitch} ${nnfswitch} ${sharingswitch} -f ltl -u --sets-of-time-points-uc --Parikh-algorithm=Sawa"
	            cmd="${RUN} --time-limit=${TIMEOUT} --space-limit=${MEMOUT} --report-rate=0 ${cmd}"
                    rm -f ${examplefile}.setsoftimepoints.{internal,snf,ltlc,ltl}
	            ;;
            esac;

            echo -n -e "${logfile}...\n"
            echo -n -e "${cmd}\n"
            echo -n -e "${cmd}\n" >${logfile}

	    ${cmd} "${examplefile}" >>${logfile} 2>&1

            killall -q -u `whoami` trp++uc

            case ${meth} in
	        none)
	            ;;
	        simple)
                    if [ -f ${examplefile}.simple.proof.internal ]; then mv ${examplefile}.simple.proof.internal ${examplefile}.simple.${sharing}.internal; fi
                    if [ -f ${examplefile}.simple.proof.snf ]; then mv ${examplefile}.simple.proof.snf ${examplefile}.simple.${sharing}.snf; fi
                    if [ -f ${examplefile}.simple.proof.ltlc ]; then mv ${examplefile}.simple.proof.ltlc ${examplefile}.simple.${sharing}.ltlc; fi
                    if [ -f ${examplefile}.simple.proof.ltl ]; then mv ${examplefile}.simple.proof.ltl ${examplefile}.simple.${sharing}.ltl; fi
	            ;;
	        setsoftimepointsg)
                    if [ -f ${examplefile}.setsoftimepoints.proof.internal ]; then mv ${examplefile}.setsoftimepoints.proof.internal ${examplefile}.setsoftimepointsg.${sharing}.internal; fi
                    if [ -f ${examplefile}.setsoftimepoints.proof.snf ]; then mv ${examplefile}.setsoftimepoints.proof.snf ${examplefile}.setsoftimepointsg.${sharing}.snf; fi
                    if [ -f ${examplefile}.setsoftimepoints.proof.ltlc ]; then mv ${examplefile}.setsoftimepoints.proof.ltlc ${examplefile}.setsoftimepointsg.${sharing}.ltlc; fi
                    if [ -f ${examplefile}.setsoftimepoints.proof.ltl ]; then mv ${examplefile}.setsoftimepoints.proof.ltl ${examplefile}.setsoftimepointsg.${sharing}.ltl; fi
	            ;;
	        setsoftimepointss)
                    if [ -f ${examplefile}.setsoftimepoints.proof.internal ]; then mv ${examplefile}.setsoftimepoints.proof.internal ${examplefile}.setsoftimepointss.${sharing}.internal; fi
                    if [ -f ${examplefile}.setsoftimepoints.proof.snf ]; then mv ${examplefile}.setsoftimepoints.proof.snf ${examplefile}.setsoftimepointss.${sharing}.snf; fi
                    if [ -f ${examplefile}.setsoftimepoints.proof.ltlc ]; then mv ${examplefile}.setsoftimepoints.proof.ltlc ${examplefile}.setsoftimepointss.${sharing}.ltlc; fi
                    if [ -f ${examplefile}.setsoftimepoints.proof.ltl ]; then mv ${examplefile}.setsoftimepoints.proof.ltl ${examplefile}.setsoftimepointss.${sharing}.ltl; fi
	            ;;
            esac;

            echo -n -e " done.\n"
        done
    done
done
