#!/bin/bash

#---------------------------------------------------------------------------#
# Script for running benchmarks
#
# Original by V. Schuppan
#---------------------------------------------------------------------------#

TIMEOUT=600
MEMOUT=6144

# examples and methods
selfpath=`dirname ${0}`
. ${selfpath}/config_examples.bash

TMPDIR=/tmp

#------------------------------------------------------------------------------#
# main
#

case "`hostname`" in
    scheffauer)
        TOPDIR=/home/schuppan/projects/trpuc
        RUN=/usr/local/src/run-1.4-mine/run
        TRP=${TOPDIR}/trpuc/trunk/bin/trp++uc
        ;;
    *)
        echo "Error: host `hostname` not configured."
        exit 1
        ;;
esac;

for example in ${examples[@]}; do
    for meth in none proof_aug2 proof_bfsloopitinitcg proof_bfsloopitinitce proof_bfsloopconclusion2e proof_noprunemain proof_nopruneloopits proof_all proof proofdeletion deletion ; do
        nnfswitch=
        (echo "${example}"|grep -q "^lift") && nnfswitch=--no-nnf

        examplefile="${example}.trp"
        logfile="${example}.${meth}.log"
        rm -f ${logfile}
            
        cmd=
        case ${meth} in
	    none)
                cmd="${TRP} -s BFS ${nnfswitch} -f ltl -u none"
	        cmd="${RUN} --time-limit=${TIMEOUT} --space-limit=${MEMOUT} --report-rate=0 ${cmd}"
	        ;;
	    proof)
                cmd="${TRP} -s BFS ${nnfswitch} -f ltl -u simple -a proof"
	        cmd="${RUN} --time-limit=${TIMEOUT} --space-limit=${MEMOUT} --report-rate=0 ${cmd}"
                rm -f ${examplefile}.simple.proof.{internal,snf,ltlc,ltl}
	        ;;
	    proofdeletion)
                cmd="${TRP} -s BFS ${nnfswitch} -f ltl -u simple -a proofdeletion"
	        cmd="${RUN} --time-limit=${TIMEOUT} --space-limit=${MEMOUT} --report-rate=0 ${cmd}"
                rm -f ${examplefile}.simple.proofdeletion.{internal,snf,ltlc,ltl}
	        ;;
	    proof_aug2)
                cmd="${TRP} -s BFS ${nnfswitch} -f ltl -u simple -a proof --no-rgnoedge-aug2"
	        cmd="${RUN} --time-limit=${TIMEOUT} --space-limit=${MEMOUT} --report-rate=0 ${cmd}"
                rm -f ${examplefile}.simple.proof.{internal,snf,ltlc,ltl}
	        ;;
	    proof_bfsloopitinitcg)
                cmd="${TRP} -s BFS ${nnfswitch} -f ltl -u simple -a proof --no-rgnoedge-bfsloopitinitcg"
	        cmd="${RUN} --time-limit=${TIMEOUT} --space-limit=${MEMOUT} --report-rate=0 ${cmd}"
                rm -f ${examplefile}.simple.proof.{internal,snf,ltlc,ltl}
	        ;;
	    proof_bfsloopitinitce)
                cmd="${TRP} -s BFS ${nnfswitch} -f ltl -u simple -a proof --no-rgnoedge-bfsloopitinitce"
	        cmd="${RUN} --time-limit=${TIMEOUT} --space-limit=${MEMOUT} --report-rate=0 ${cmd}"
                rm -f ${examplefile}.simple.proof.{internal,snf,ltlc,ltl}
	        ;;
	    proof_bfsloopconclusion2e)
                cmd="${TRP} -s BFS ${nnfswitch} -f ltl -u simple -a proof --no-rgnoedge-bfsloopconclusion2e"
	        cmd="${RUN} --time-limit=${TIMEOUT} --space-limit=${MEMOUT} --report-rate=0 ${cmd}"
                rm -f ${examplefile}.simple.proof.{internal,snf,ltlc,ltl}
	        ;;
	    proof_noprunemain)
                cmd="${TRP} -s BFS ${nnfswitch} -f ltl -u simple -a proof --no-prune-main-fwd-reachable --no-prune-main-bwd-reachable"
	        cmd="${RUN} --time-limit=${TIMEOUT} --space-limit=${MEMOUT} --report-rate=0 ${cmd}"
                rm -f ${examplefile}.simple.proof.{internal,snf,ltlc,ltl}
	        ;;
	    proof_nopruneloopits)
                cmd="${TRP} -s BFS ${nnfswitch} -f ltl -u simple -a proof --no-prune-failed-loop-search-its"
	        cmd="${RUN} --time-limit=${TIMEOUT} --space-limit=${MEMOUT} --report-rate=0 ${cmd}"
                rm -f ${examplefile}.simple.proof.{internal,snf,ltlc,ltl}
	        ;;
	    proof_all)
                cmd="${TRP} -s BFS ${nnfswitch} -f ltl -u simple -a proof --no-rgnoedge-aug2 --no-rgnoedge-bfsloopitinitcg --no-rgnoedge-bfsloopitinitce --no-rgnoedge-bfsloopconclusion2e --no-prune-main-fwd-reachable --no-prune-main-bwd-reachable --no-prune-failed-loop-search-its"
	        cmd="${RUN} --time-limit=${TIMEOUT} --space-limit=${MEMOUT} --report-rate=0 ${cmd}"
                rm -f ${examplefile}.simple.proof.{internal,snf,ltlc,ltl}
	        ;;
	    deletion)
                cmd="${TRP} -s BFS ${nnfswitch} -f ltl -u simple -a deletion"
	        cmd="${RUN} --time-limit=${TIMEOUT} --space-limit=${MEMOUT} --report-rate=0 ${cmd}"
                rm -f ${examplefile}.simple.deletion.{internal,snf,ltlc,ltl}
	        ;;
        esac;

        echo -n -e "${logfile}...\n"
        echo -n -e "${cmd}\n"
        echo -n -e "${cmd}\n" >${logfile}

	${cmd} "${examplefile}" >>${logfile} 2>&1

        killall -q -u `whoami` trp++uc

        if [ "${meth}" != "none" -a "${meth}" != "proof" -a "${meth}" != "proofdeletion"  -a "${meth}" != "deletion" ]; then
            if [ -f ${examplefile}.simple.proof.internal ]; then mv ${examplefile}.simple.proof.internal ${examplefile}.simple.${meth}.internal; fi
            if [ -f ${examplefile}.simple.proof.snf ]; then mv ${examplefile}.simple.proof.snf ${examplefile}.simple.${meth}.snf; fi
            if [ -f ${examplefile}.simple.proof.ltlc ]; then mv ${examplefile}.simple.proof.ltlc ${examplefile}.simple.${meth}.ltlc; fi
            if [ -f ${examplefile}.simple.proof.ltl ]; then mv ${examplefile}.simple.proof.ltl ${examplefile}.simple.${meth}.ltl; fi
        fi
        
        echo -n -e " done.\n"
    done
done
