/************************************************************
 *    Copyright (C) 2012-2013                               *
 *    Viktor Schuppan (Viktor.Schuppan@gmx.de)              *
 *                                                          *
 *    This program is free software; you can redistribute   *
 *    it and/or modify it under the terms of the GNU        *
 *    General Public License as published by the Free       *
 *    Software Foundation, either version 3 of the License, *
 *    or (at your option) any later version.                *
 *                                                          *
 *    This program is distributed in the hope that it will  *
 *    be useful, but WITHOUT ANY WARRANTY; without even     *
 *    the implied warranty of MERCHANTABILITY or FITNESS    *
 *    FOR A PARTICULAR PURPOSE.  See the GNU General Public *
 *    License for more details.                             *
 *                                                          *
 *    You should have received a copy of the GNU General    *
 *    Public License along with this program.  If not, see  *
 *    <http://www.gnu.org/licenses/>.                       *
 ************************************************************/
#include <iostream>
#include <string>
#include <stdio.h>
#include <stdlib.h>
#include "formula.h"
#include "getopt/options.h"
#include "helpers.h"
#include "misc/tracer.h"
#include "modules.h"
#include "trp_ltl_parser.h"

extern "C"
{
  extern FILE *trpltl_yyin;
}
extern void trpltl_yyerror(const char *error);
extern int trpltl_yyparse(void);
extern struct list *formula_list;

namespace BuilderLtl
{
  TrpLtlParser::TrpLtlParser(TRPPPOptions const & options)
    : myFormulaList(),
      myOptions(options)
  { } // TrpLtlParser::TrpLtlParser

  void
  TrpLtlParser::parseLtl()
  {
    trpltl_yyin = fopen(myOptions.getFileName().c_str(), "r");
    if(!trpltl_yyin) {
      perror("Input file");
      exit(1);
    }

    trpltl_yyparse();

    fclose(trpltl_yyin);

    for(struct list *it = formula_list; !list_IsEmpty(it); it = list_Tail(it)) {
      tree* t = (tree*)list_Element(it);
      if(t) {
        myFormulaList.push_back(transformToTree((tree*)list_Element(it)));
      }
      tree_Delete(t);
    }
    list_Delete(formula_list);

    TRACE(builderltlModule, {
        std::cout << "TrpLtlParser: parsed LTL formula:"
                  << std::endl;
        for (TreeNodeList::const_iterator it = myFormulaList.begin();
             it != myFormulaList.end();
             ++it)
          {
            std::cout << *it << std::endl;
          }
      });
  } // TrpLtlParser::parseLtl

  TreeNodeList
  TrpLtlParser::getLtlFormulaList()
  {
    return myFormulaList;
  } // TrpLtlParser::getLtlFormulaList
} // namespace BuilderLtl
