/************************************************************
 *    Copyright (C) 2014                                    *
 *    Viktor Schuppan (Viktor.Schuppan@gmx.de)              *
 *                                                          *
 *    This program is free software; you can redistribute   *
 *    it and/or modify it under the terms of the GNU        *
 *    General Public License as published by the Free       *
 *    Software Foundation, either version 3 of the License, *
 *    or (at your option) any later version.                *
 *                                                          *
 *    This program is distributed in the hope that it will  *
 *    be useful, but WITHOUT ANY WARRANTY; without even     *
 *    the implied warranty of MERCHANTABILITY or FITNESS    *
 *    FOR A PARTICULAR PURPOSE.  See the GNU General Public *
 *    License for more details.                             *
 *                                                          *
 *    You should have received a copy of the GNU General    *
 *    Public License along with this program.  If not, see  *
 *    <http://www.gnu.org/licenses/>.                       *
 ************************************************************/
#ifndef __LCHO_PARTITIONER_H__
#define __LCHO_PARTITIONER_H__

#include <cstddef>
#include <map>
#include <set>
#include <boost/pending/disjoint_sets.hpp>
#include <boost/property_map/property_map.hpp>
#include "getopt/options.h"
#include "clause_handle.h"
#include "inference_rule_edge_labeling.h"
#include "lcho_partition.h"
#include "literal_clauseh_occurrence.h"
#include "resolution_graph.h"
#include "unsat_core_private.h"

namespace UnsatCore
{
  class LCHOPartitioner
  {
  private:
    typedef ResolutionGraph::Graph Graph;
    typedef ResolutionGraph::Vertex Vertex;
    typedef ResolutionGraph::Edge Edge;
    typedef ResolutionGraph::VertexIterator VertexIterator;
  private:
    Graph & myResolutionGraph;
    std::map<Vertex, ClauseHandle> & myMapVertexToClauseh;
    std::map<Edge, InferenceRuleEdgeLabeling> &
      myMapEdgeToInferenceRuleEdgeLabeling;
    ClauseHandleSet & myCoreStartingClausehs;
    MapLCHOToLCHOPartition & myMapLCHOToLCHOPartition;
    std::map<LCHOPartition, unsigned long> & myMapLCHOPartitionToIndex;
    std::map<Partition, Literal> & myMapPartitionToLiteral;
    unsigned long & myNoPropositionsReachableSubgraph;
    unsigned long & myNoPropositionOccurrencesReachableSubgraph;
    unsigned long & myNoPartitionsPerPropositionPeakReachableSubgraph;
    unsigned long & myNoPartitionsPerPropositionGE2ReachableSubgraph;
    unsigned long & myNoPropositionsCore;
    unsigned long & myNoPropositionOccurrencesCore;
    unsigned long & myNoPartitionsPerPropositionPeakCore;
    unsigned long & myNoPartitionsPerPropositionGE2Core;
    unsigned long & myNoPropositionsCoreNonNVV;
    unsigned long & myNoPropositionOccurrencesCoreNonNVV;
    unsigned long & myNoPartitionsPerPropositionPeakCoreNonNVV;
    unsigned long & myNoPartitionsPerPropositionGE2CoreNonNVV;
    TRPPPOptions myOptions;
  public:
    LCHOPartitioner(Graph & resolutionGraph,
                    std::map<Vertex, ClauseHandle> & mapVertexToClauseh,
                    std::map<Edge, InferenceRuleEdgeLabeling> &
                    mapEdgeToInferenceRuleEdgeLabeling,
                    ClauseHandleSet & coreStartingClausehs,
                    MapLCHOToLCHOPartition & mapLCHOToLCHOPartition,
                    std::map<LCHOPartition, unsigned long> &
                    mapLCHOPartitionToIndex,
                    std::map<Partition, Literal> & mapPartitionToLiteral,
                    unsigned long & noPropositionsReachableSubgraph,
                    unsigned long & noPropositionOccurrencesReachableSubgraph,
                    unsigned long &
                    noPartitionsPerPropositionPeakReachableSubgraph,
                    unsigned long &
                    noPartitionsPerPropositionGE2ReachableSubgraph,
                    unsigned long & noPropositionsCore,
                    unsigned long & noPropositionOccurrencesCore,
                    unsigned long & noPartitionsPerPropositionPeakCore,
                    unsigned long & noPartitionsPerPropositionGE2Core,
                    unsigned long & noPropositionsCoreNonNVV,
                    unsigned long & noPropositionOccurrencesCoreNonNVV,
                    unsigned long & noPartitionsPerPropositionPeakCoreNonNVV,
                    unsigned long & noPartitionsPerPropositionGE2CoreNonNVV,
                    TRPPPOptions const & options);
    void computeLCHOPartitionsSNF();
  public:
    typedef std::map<LCHOPartition, std::size_t> MapLCHOPartitionToSizeT;
    typedef std::map<LCHOPartition, LCHOPartition>
      MapLCHOPartitionToLCHOPartition;
    typedef boost::associative_property_map<MapLCHOPartitionToSizeT>
      BapmMapLCHOPartitionToSizeT;
    typedef boost::associative_property_map<MapLCHOPartitionToLCHOPartition>
      BapmMapLCHOPartitionToLCHOPartition;
    typedef boost::disjoint_sets<BapmMapLCHOPartitionToSizeT,
      BapmMapLCHOPartitionToLCHOPartition>
      LCHOPartitionDisjointSets;
  private:
    void union_set_lchos(LCHOPartitionDisjointSets & ufind,
                         LiteralClausehOccurrence const & lcho1,
                         LiteralClausehOccurrence const & lcho2);
    Clause::const_iterator find_l_aug2(PClause const & pc);
    void union_set_resolved_upon_lits(LCHOPartitionDisjointSets & ufind,
                                      ClauseHandle const & chp1,
                                      ClauseHandle const & chp2);
    void union_set_bodies_ii(LCHOPartitionDisjointSets & ufind,
                             ClauseHandle const & chc,
                             ClauseHandle const & chp);
    void union_set_bodies_in(LCHOPartitionDisjointSets & ufind,
                             ClauseHandle const & chc,
                             ClauseHandle const & chp);
    void union_set_bodies_nn(LCHOPartitionDisjointSets & ufind,
                             ClauseHandle const & chc,
                             ClauseHandle const & chp);
    void union_set_bodies_xn(LCHOPartitionDisjointSets & ufind,
                             ClauseHandle const & chc,
                             ClauseHandle const & chp);
    void union_set_bodies_xx(LCHOPartitionDisjointSets & ufind,
                             ClauseHandle const & chc,
                             ClauseHandle const & chp);
    typedef bool (*LiteralPredicate)(Literal const &);
    void union_set_bodies(LCHOPartitionDisjointSets & ufind,
                          ClauseHandle const & chc,
                          ClauseHandle const & chp,
                          LiteralPredicate const lpc,
                          LiteralPredicate const lpp);
    void union_set_l_n(LCHOPartitionDisjointSets & ufind,
                       ClauseHandle const & chc,
                       ClauseHandle const & chp);
    void union_set_l_x(LCHOPartitionDisjointSets & ufind,
                       ClauseHandle const & chc,
                       ClauseHandle const & chp);
    void union_set_l(LCHOPartitionDisjointSets & ufind,
                     ClauseHandle const & chc,
                     ClauseHandle const & chp,
                     LiteralPredicate const lpc);
    ClauseHandle const & find_eclauseh_l(Literal const & l);
    void collect_statistics_in_core_lcho(LiteralClausehOccurrence const & lcho,
                                        std::set<Proposition> & seenProposition,
                                         LCHOPartitionSet & seenLCHOPartition,
                  std::map<Proposition, unsigned long> & mapPropositionToIndex);
    bool isNVVNatural(std::string const & s) const;
  }; // class LCHOPartitioner

  bool lpInit(Literal const & l);
  bool lpNow(Literal const & l);
  bool lpNext(Literal const & l);
} // namespace UnsatCore
#endif // __LCHO_PARTITIONER_H__
