/************************************************************
 *    Copyright (C) 2012                                    *
 *    Viktor Schuppan (Viktor.Schuppan@gmx.de)              *
 *                                                          *
 *    This program is free software; you can redistribute   *
 *    it and/or modify it under the terms of the GNU        *
 *    General Public License as published by the Free       *
 *    Software Foundation, either version 3 of the License, *
 *    or (at your option) any later version.                *
 *                                                          *
 *    This program is distributed in the hope that it will  *
 *    be useful, but WITHOUT ANY WARRANTY; without even     *
 *    the implied warranty of MERCHANTABILITY or FITNESS    *
 *    FOR A PARTICULAR PURPOSE.  See the GNU General Public *
 *    License for more details.                             *
 *                                                          *
 *    You should have received a copy of the GNU General    *
 *    Public License along with this program.  If not, see  *
 *    <http://www.gnu.org/licenses/>.                       *
 ************************************************************/
#include "stl_tim/attribute.h"
#include "stl_tim/clause.h"
#include "stl_tim/literal.h"
#include "stl_tim/pclause.h"
#include "unsat_core_private.h"
#include "misc.h"

namespace UnsatCore
{
  // Copied from adaptor/stl_tim_adaptor.h::IsInitial
  bool
  isPClauseInitial(PClause const & pclause)
  {
    if (pclause->size() == 0)
      return true; // consider the empty clause as initial
    else if(pclause->getLeadingLiteral().getAttribute() ==
            PropositionalProver::initial_attr)
      return true;
    else
      return false;
  } // isPClauseInitial

  // Different from adaptor/stl_tim_adaptor.h::IsUniversal: if the
  // attribute of the leading literal is step_now the clause is
  // considered to be universal regardless of whether in loop search
  // mode or not.
  bool
  isPClauseUniversal(PClause const & pclause)
  {
    if (pclause->size() == 0)
      return false; // it is initial
    else if (pclause->getLeadingLiteral().getAttribute() ==
             PropositionalProver::universal_attr ||
             pclause->getLeadingLiteral().getAttribute() ==
             PropositionalProver::step_now_attr)
      return true;
    else
      return false;
  } // isPClauseUniversal

  // Different from adaptor/stl_tim_adaptor.h::IsStep: if the
  // attribute of the leading literal is step_now the clause is
  // considered to be universal regardless of whether in loop search
  // mode or not.
  bool
  isPClauseStep(PClause const & pclause)
  {
    if (pclause->size() == 0) 
      return false; // it is initial
    else if (pclause->getLeadingLiteral().getAttribute() ==
             PropositionalProver::step_next_attr)
      return true;
    else
      return false;
  } // isPClauseUniversal

  bool
  isPClauseEmpty(PClause const & pclause)
  {
    return (pclause->size() == 0) ;
  } // isPClauseEmpty
} // namespace UnsatCore
