/************************************************************
 *    Copyright (C) 2012-2013                               *
 *    Viktor Schuppan (Viktor.Schuppan@gmx.de)              *
 *                                                          *
 *    This program is free software; you can redistribute   *
 *    it and/or modify it under the terms of the GNU        *
 *    General Public License as published by the Free       *
 *    Software Foundation, either version 3 of the License, *
 *    or (at your option) any later version.                *
 *                                                          *
 *    This program is distributed in the hope that it will  *
 *    be useful, but WITHOUT ANY WARRANTY; without even     *
 *    the implied warranty of MERCHANTABILITY or FITNESS    *
 *    FOR A PARTICULAR PURPOSE.  See the GNU General Public *
 *    License for more details.                             *
 *                                                          *
 *    You should have received a copy of the GNU General    *
 *    Public License along with this program.  If not, see  *
 *    <http://www.gnu.org/licenses/>.                       *
 ************************************************************/
#include <unordered_map>
#include "misc/assert.h"
#include "unsat_core_private.h"
#include "pclause_resolution_map.h"

namespace UnsatCore
{
  PClauseResolutionMap::PClauseResolutionMap()
    : myMap()
  { }

  PClauseResolutionMap::~PClauseResolutionMap()
  {
    Assert(myMap.empty(), "myMap not empty.");
  }

  void PClauseResolutionMap::reset()
  {
    Assert(myMap.empty(), "myMap not empty.");
  }

  void PClauseResolutionMap::store(PClause const & pc1, PClause const & pc2)
  {
    Assert(myMap.find(pc1) == myMap.end(), "PClause already present in myMap.");
    myMap[pc1] = pc2;
  }
  
  // Destructive.
  PClause PClauseResolutionMap::get(PClause const & pc)
  {
    Assert(myMap.find(pc) != myMap.end(), "PClause not present in myMap.");
    PClause result = myMap[pc];
    erase(pc);
    return result;
  }

  void PClauseResolutionMap::erase(PClause const & pc)
  {
    Assert(myMap.find(pc) != myMap.end(), "PClause not present in myMap.");
    std::unordered_map<PClause, PClause>::iterator it =
      myMap.find(pc);
    myMap.erase(it);
  }
} // namespace UnsatCore
