/************************************************************
 *    Copyright (C) 2012-2014                               *
 *    Viktor Schuppan (Viktor.Schuppan@gmx.de)              *
 *                                                          *
 *    This program is free software; you can redistribute   *
 *    it and/or modify it under the terms of the GNU        *
 *    General Public License as published by the Free       *
 *    Software Foundation, either version 3 of the License, *
 *    or (at your option) any later version.                *
 *                                                          *
 *    This program is distributed in the hope that it will  *
 *    be useful, but WITHOUT ANY WARRANTY; without even     *
 *    the implied warranty of MERCHANTABILITY or FITNESS    *
 *    FOR A PARTICULAR PURPOSE.  See the GNU General Public *
 *    License for more details.                             *
 *                                                          *
 *    You should have received a copy of the GNU General    *
 *    Public License along with this program.  If not, see  *
 *    <http://www.gnu.org/licenses/>.                       *
 ************************************************************/
#ifndef __UNSAT_CORE_WRITER_H__
#define __UNSAT_CORE_WRITER_H__

#include <iostream>
#include <map>
#include "builder_ltl/formula.h"
#include "getopt/options.h"
#include "clause_handle.h"
#include "lcho_partition.h"
#include "literal_clauseh_occurrence.h"
#include "semi_linear_set.h"
#include "unsat_core_private.h"

namespace UnsatCore
{
  class UnsatCoreWriter
  {
  private:
    std::ostream * myOs;
    ClauseHandleSet const & myChs;
    std::map<ClauseHandle, SemiLinearSet> const & myMChToSls;
    MapLCHOToLCHOPartition const & myMLCHOToLCHOP;
    std::map<LCHOPartition, unsigned long> const & myMLCHOPToI;
    std::list<TreeNode*> const & myFormulaList;
    std::map<TreeNode*, SemiLinearSet> const & myMSfToSls;
    TRPPPOptions const & myOptions;
    std::string myNvvVarPrefix;
    std::string myPartitionVarSuffix;
  public:
    static void dumpCore(ClauseHandleSet const & chs,
                         std::map<ClauseHandle, SemiLinearSet> const & mChToSls,
                         MapLCHOToLCHOPartition const & mLCHOToLCHOP,
                       std::map<LCHOPartition, unsigned long> const & mLCHOPToI,
                         std::list<TreeNode*> const & formulaList,
                         std::map<TreeNode*, SemiLinearSet> const & mSfToSls,
                         TRPPPOptions const &options);
    static void dumpCoreBenchmarking(ClauseHandleSet const & chs,
                         std::map<ClauseHandle, SemiLinearSet> const & mChToSls,
                                    MapLCHOToLCHOPartition const & mLCHOToLCHOP,
                       std::map<LCHOPartition, unsigned long> const & mLCHOPToI,
                                     std::list<TreeNode*> const & formulaList,
                            std::map<TreeNode*, SemiLinearSet> const & mSfToSls,
                                     TRPPPOptions const & options);
    UnsatCoreWriter(std::ostream & os,
                    ClauseHandleSet const & chs,
                    std::map<ClauseHandle, SemiLinearSet> const & mChToSls,
         MapLCHOToLCHOPartition const & mLCHOToLCHOP,
                    std::map<LCHOPartition, unsigned long> const & mLCHOPToI,
                    std::list<TreeNode*> const & formulaList,
                    std::map<TreeNode*, SemiLinearSet> const & mSfToSls,
                    TRPPPOptions const & options);
    void dumpClausehs();
    void dumpClausehsSimplePartitionedInternal(bool isPartitioned);
    void dumpClausehsSimplePartitionedSNF(bool isPartitioned);
    void dumpClausehsSimplePartitionedLTLC(bool isPartitioned);
    void dumpClausehsSimplePartitionedLTL();
    void dumpClausehsSetsOfTimePointsInternal();
    void dumpClausehsSetsOfTimePointsSNF();
    void dumpClausehsSetsOfTimePointsLTLC();
    void dumpClausehsSetsOfTimePointsLTL();
    void dumpClausehSNF(ClauseHandle const & ch, bool isPartitioned);
  private:
    static void dump_core_benchmarking_aux(ClauseHandleSet const & chs,
                         std::map<ClauseHandle, SemiLinearSet> const & mChToSls,
                                    MapLCHOToLCHOPartition const & mLCHOToLCHOP,
                       std::map<LCHOPartition, unsigned long> const & mLCHOPToI,
                                       std::list<TreeNode*> const & formulaList,
                            std::map<TreeNode*, SemiLinearSet> const & mSfToSls,
                                           TRPPPOptions const & options,
                                           ExtractUnsatCoreFormat format);
    void dump_literal(Literal const & l);
    void dump_clauseh_body_LTLC(ClauseHandle const & ch,
                                          bool isPartitioned);
    void dump_clauseh_LTLC(ClauseHandle const & ch,
                                     bool isPartitioned);
    void dump_clausehs_simple_LTL_rec(TreeNode * n,
                                                bool isPositivePolarity);
    void dump_clausehs_sets_of_time_points_LTL_rec(TreeNode * n,
                                                       bool isPositivePolarity);
    void dump_clauseh_partitioned_internal(ClauseHandle const & ch);
    void dump_lcho_partitioned_internal(LiteralClausehOccurrence & lcho);
    void dump_lcho_partitioned_SNF(LiteralClausehOccurrence & lcho);
    void dump_nusmv_head();
    void dump_nusmv_tail();
  public:
    typedef std::set<std::string> StringSet;
    static std::string getUnusedVarPrefix(ClauseHandleSet const & chs,
                                          std::string const & startPrefix);
    static std::string getUnusedVarInfix(ClauseHandleSet const & chs,
                                         std::string const & startInfix);
  private:
    StringSet myApsToDeclare;
    static StringSet get_aps(ClauseHandleSet const & chs);
    std::string TRUE_STR = "True";
    std::string FALSE_STR = "False";
    std::string NOT_SNF_STR = "not";
    std::string NOT_STR = "~";
    std::string NEXT_STR = "next";
    std::string ALWAYS_STR = "always";
    std::string SOMETIME_STR = "sometime";
    std::string UNTIL_STR = "until";
    std::string UNLESS_STR = "unless";
  }; // classUnsatCoreWriter
} // namespace UnsatCore
#endif // __UNSAT_CORE_WRITER_H__
