/**************************************************************/
/* ********************************************************** */
/* *                                                        * */
/* *  Copyright (C) 2001-2011                               * */
/* *  Boris Konev                                           * */
/* *  The University of Liverpool                           * */
/* *                                                        * */
/* *  Copyright (C) 2012                                    * */
/* *  Viktor Schuppan                                       * */
/* *                                                        * */
/* *  This program is free software; you can redistribute   * */
/* *  it and/or modify it under the terms of the GNU        * */
/* *  General Public License as published by the Free       * */
/* *  Software Foundation; either version 2 of the License, * */
/* *  or (at your option) any later version.                * */
/* *                                                        * */
/* *  This program is distributed in the hope that it will  * */
/* *  be useful, but WITHOUT ANY WARRANTY; without even     * */
/* *  the implied warranty of MERCHANTABILITY or FITNESS    * */
/* *  FOR A PARTICULAR PURPOSE.  See the GNU General Public * */
/* *  License for more details.                             * */
/* *                                                        * */
/* *  You should have received a copy of the GNU General    * */
/* *  Public License along with this program; if not, write * */
/* *  to the Free Software Foundation, Inc., 59 Temple      * */
/* *  Place, Suite 330, Boston, MA  02111-1307  USA         * */
/* *                                                        * */
/* *                                                        * */
/* ********************************************************** */
/**************************************************************/
#ifndef __UCLAUSE_H__
#define __UCLAUSE_H__

#include <string>
#include "stl_tim/clause.h"
#include "stl_tim/pclause.h"

namespace Adaptors
{
  // all adaptors _must define_ the following types:
  // UClause: U:(literal, literal,...)
  class UClause
  {
  public:
    // public types
    typedef PropositionalProver::PClause internal_clause_rep;
    // const_clause_iterator iterates over internal representation of
    // clauses (internal_clause_rep*)
    typedef PropositionalProver::Clause::const_iterator clause_const_iterator;
  private:
    internal_clause_rep myClause;
  public:
    typedef clause_const_iterator const_iterator;
  UClause(internal_clause_rep clause)
    : myClause(clause)
    { }
    const_iterator
      begin() const
    {
      return (myClause->begin());
    }
    const_iterator
      end() const
    {
      return (myClause->end());
    }
    const internal_clause_rep&
      getInternalRep() const
    {
      return myClause;
    }
    const std::string&
      getInfo() const
    {
      return myClause->getInfo();
    }
    const int
      getId() const
    {
      return myClause->getId();
    }
    bool
      operator<(UClause const & other) const
    {
      return myClause < other.myClause;
    }
  }; // class UClause
} // namespace Adaptors
#endif // __UCLAUSE_H__
