/************************************************************
 *    Copyright (C) 2012                                    *
 *    Viktor Schuppan (Viktor.Schuppan@gmx.de)              *
 *                                                          *
 *    This program is free software; you can redistribute   *
 *    it and/or modify it under the terms of the GNU        *
 *    General Public License as published by the Free       *
 *    Software Foundation, either version 3 of the License, *
 *    or (at your option) any later version.                *
 *                                                          *
 *    This program is distributed in the hope that it will  *
 *    be useful, but WITHOUT ANY WARRANTY; without even     *
 *    the implied warranty of MERCHANTABILITY or FITNESS    *
 *    FOR A PARTICULAR PURPOSE.  See the GNU General Public *
 *    License for more details.                             *
 *                                                          *
 *    You should have received a copy of the GNU General    *
 *    Public License along with this program.  If not, see  *
 *    <http://www.gnu.org/licenses/>.                       *
 ************************************************************/
#ifndef __TRP_LTL_PARSER_H__
#define __TRP_LTL_PARSER_H__

#include "adaptor/stl_tim_adaptor.h"
#include "getopt/options.h"
#include "trim/trim.h"
#include "unsat_core/clause_handle.h"
#include "formula.h"

namespace TrpLtlParser
{
  class TrpLtlParser
  {
  public:
    typedef TRIMs::TRIM<Adaptors::Adaptor> ClauseSet;
  public:
    TrpLtlParser(TRPPPOptions const & options);
    void parseLtl();
    void replaceEquivalencesLtl();
    void nnfLtl();
    void simplifyLtl();
    void translateLtlToSnf();
    void simplifySnf();
    void checkSnfForEmptyClause();
    ClauseSet getSnfClauseSet();
    TreeNodeList getLtlFormulaList();
    std::map<TreeNode*, UnsatCore::ClauseHandleSet>
      getMapSubformulaToClausehsNow();
    std::map<TreeNode*, UnsatCore::ClauseHandleSet>
      getMapSubformulaToClausehsNext();
    std::map<TreeNode*, UnsatCore::ClauseHandleSet>
      getMapSubformulaToClausehsSometime();
  private:
    TreeNodeList myFormulaList;
    UnsatCore::ClauseHandleSet myClausehSet;
    ClauseSet myClauseSet;
    std::map<TreeNode*, UnsatCore::ClauseHandleSet>
      myMapSubformulaToClausehsNow;
    std::map<TreeNode*, UnsatCore::ClauseHandleSet>
      myMapSubformulaToClausehsNext;
    std::map<TreeNode*, UnsatCore::ClauseHandleSet>
      myMapSubformulaToClausehsSometime;
    TRPPPOptions const & myOptions;
  }; // class TrpLtlParser
} // namespace TrpLtlParser
#endif // __TRP_LTL_PARSER_H__
