/**************************************************************/
/* ********************************************************** */
/* *                                                        * */
/* *  Copyright (C) 2001-2011                               * */
/* *  Boris Konev                                           * */
/* *  The University of Liverpool                           * */
/* *                                                        * */
/* *  Copyright (C) 2012                                    * */
/* *  Viktor Schuppan                                       * */
/* *                                                        * */
/* *  This program is free software; you can redistribute   * */
/* *  it and/or modify it under the terms of the GNU        * */
/* *  General Public License as published by the Free       * */
/* *  Software Foundation; either version 2 of the License, * */
/* *  or (at your option) any later version.                * */
/* *                                                        * */
/* *  This program is distributed in the hope that it will  * */
/* *  be useful, but WITHOUT ANY WARRANTY; without even     * */
/* *  the implied warranty of MERCHANTABILITY or FITNESS    * */
/* *  FOR A PARTICULAR PURPOSE.  See the GNU General Public * */
/* *  License for more details.                             * */
/* *                                                        * */
/* *  You should have received a copy of the GNU General    * */
/* *  Public License along with this program; if not, write * */
/* *  to the Free Software Foundation, Inc., 59 Temple      * */
/* *  Place, Suite 330, Boston, MA  02111-1307  USA         * */
/* *                                                        * */
/* *                                                        * */
/* ********************************************************** */
/**************************************************************/
#ifndef __OPTIONS_H__
#define __OPTIONS_H__

#include <iostream>
#include <string>

#include "genoptions.h"
#include "misc/exception.h"

namespace Exceptions
{
    class OptionException : public Exception
    {
    public:
        virtual void 
        module(std::ostream& os) const
        {
            os << "Program options: ";
        }
    }; // class ClauseSetException
    class WrongOption : public OptionException
    {
    private:
        const std::string myOption;
    public:
        WrongOption(const std::string& option)
        : myOption (option)
        { }
        virtual void 
        what (std::ostream& os) const
        {
            os << myOption << std::endl;
        }
    }; //class IndexInconsistent
}

typedef enum { INPUT_FORMAT_SNF,
               INPUT_FORMAT_LTL } InputFormat;

typedef enum { EXTRACT_UNSAT_CORE_MODE_NONE,
               EXTRACT_UNSAT_CORE_MODE_SIMPLE,
               EXTRACT_UNSAT_CORE_MODE_POSITIONSETS }
  ExtractUnsatCoreMode;

typedef enum { EXTRACT_UNSAT_CORE_FORMAT_INTERNAL,
               EXTRACT_UNSAT_CORE_FORMAT_SNF,
               EXTRACT_UNSAT_CORE_FORMAT_LTLC,
               EXTRACT_UNSAT_CORE_FORMAT_LTL } ExtractUnsatCoreFormat;

typedef enum { EXTRACT_UNSAT_CORE_PARIKH_ALGORITHM_GAWRYCHOWSKI,
               EXTRACT_UNSAT_CORE_PARIKH_ALGORITHM_SAWA }
  ExtractUnsatCoreParikhAlgorithm;

class
TRPPPOptions
{
public:
    TRPPPOptions(int argc, char** argv);

    const std::string&
    getFileName() const  { return myFileName; }

    const std::string&
    getOrderFileName() const  { return myOrderFile; }

    InputFormat
    getInputFormat() const { return myInputFormat; }

    bool
    isShowInput() const  { return myShowInput; }

    bool
    isShowResult() const { return myShowResult; }

    bool 
    isQuiet() const      { return myQuiet; }

    bool
    isUsePretest() const { return myUsePretest; }

    bool
    isDFS() const        { return myDFS; }

    bool
    isUseFSR() const { return myUseFSR; }

    bool
    isExtractUnsatCore() const
    { return (myExtractUnsatCoreMode != EXTRACT_UNSAT_CORE_MODE_NONE); }

    ExtractUnsatCoreMode
    getExtractUnsatCoreMode() const { return myExtractUnsatCoreMode; }

    const std::string &
    getExtractUnsatCoreFileName() const { return myExtractUnsatCoreFileName; }

    ExtractUnsatCoreFormat
    getExtractUnsatCoreFormat() const { return myExtractUnsatCoreFormat; }

    ExtractUnsatCoreParikhAlgorithm
    getExtractUnsatCoreParikhAlgorithm() const
    { return myExtractUnsatCoreParikhAlgorithm; }

    bool
    isNoNnf() const { return myNoNnf; }

    bool
    isNoLTLSimplification() const { return myNoLTLSimplification; }

    bool
    isNoDirectClauses() const { return myNoDirectClauses; }

    bool
    isNoEclauseReduction() const { return myNoEclauseReduction; }

    bool
    isNoSharing() const { return myNoSharing; }

    bool
    isNoSorting() const { return myNoSorting; }

    bool
    isNoSNFSimplification() const { return myNoSNFSimplification; }

    bool
    isNoUnsatCoreSimplification() const { return myNoUnsatCoreSimplification; }

private:
    void
    reportFailure(std::string s = "");

    std::string
    myFileName;

    std::string 
    myOrderFile;

    InputFormat
    myInputFormat;

    bool 
    myShowInput;

    bool
    myShowResult;

    bool 
    myQuiet;

    bool 
    myDFS;

    bool
    myUsePretest;

    bool
    myUseFSR;

    bool
    myExtractUnsatCore;

    ExtractUnsatCoreMode
    myExtractUnsatCoreMode;

    std::string
    myExtractUnsatCoreFileName;

    ExtractUnsatCoreFormat
    myExtractUnsatCoreFormat;

    ExtractUnsatCoreParikhAlgorithm
    myExtractUnsatCoreParikhAlgorithm;

    bool
    myNoNnf;

    bool
    myNoLTLSimplification;

    bool
    myNoDirectClauses;

    bool
    myNoEclauseReduction;

    bool
    myNoSharing;

    bool
    myNoSorting;

    bool
    myNoSNFSimplification;

    bool
    myNoUnsatCoreSimplification;
};
#endif //  __OPTIONS_H__
