#!/bin/bash

#------------------------------------------------------------------------------#
# configuration
#
BOOST_PATH=/usr/local/src/boost_1_28_0/
DST_PATH=tmpboost
BCP=/usr/bin/bcp

#------------------------------------------------------------------------------#
# checks
#
tmp=`pwd|egrep "^.*/src$"`
if [ "${tmp}" == "" ]; then
    echo "Error: must be run from the src directory of a trp++ repository."
    exit 1
fi
if [ -d ${DST_PATH} ]; then
    echo "Error: ${DST_PATH} directory exists."
    exit 1
fi
if [ ! -d ${BOOST_PATH} ]; then
    echo "Error: boost library not found at ${BOOST_PATH}."
    exit 1
fi

#------------------------------------------------------------------------------#
# main
#
modules=`find . -type f \
    \( \
    -name "*.cc" -o \
    -name "*.h"  -o \
    -name "genoptions.h_profile" -o \
    -name "genoptions.h_debug" -o \
    -name "genoptions.h_release" -o \
    -name "parse.y" -o \
    -name "scan.fl" \
    \) \
    \( \( \
    -path "*/boost/*" -o \
    -path "*/not-used/*" -o \
    -path "*/sav/*" -o \
    -path "*/stl_tim/alternatives/*" -o \
    -path "*/tools/*" \
       \) \
    -prune -o \
    -print \
    \)`

mkdir -p ${DST_PATH}

# Below, the simple version gives the same result, so...
${BCP} --boost=${BOOST_PATH} --scan ${modules} ${DST_PATH}
#boostmodules=`grep "^#include.*boost" ${modules} |\
#              sed -e "s/^.*\(boost[A-Za-z0-9_/.-]*\).*$/\1/g" |\
#              sort |\
#              uniq`
#${BCP} --boost=${BOOST_PATH} --list ${boostmodules}

#------------------------------------------------------------------------------#
# clean up and exit
#
exit 0
