/************************************************************
 *    Copyright (C) 2012                                    *
 *    Viktor Schuppan (Viktor.Schuppan@gmx.de)              *
 *                                                          *
 *    This program is free software; you can redistribute   *
 *    it and/or modify it under the terms of the GNU        *
 *    General Public License as published by the Free       *
 *    Software Foundation, either version 3 of the License, *
 *    or (at your option) any later version.                *
 *                                                          *
 *    This program is distributed in the hope that it will  *
 *    be useful, but WITHOUT ANY WARRANTY; without even     *
 *    the implied warranty of MERCHANTABILITY or FITNESS    *
 *    FOR A PARTICULAR PURPOSE.  See the GNU General Public *
 *    License for more details.                             *
 *                                                          *
 *    You should have received a copy of the GNU General    *
 *    Public License along with this program.  If not, see  *
 *    <http://www.gnu.org/licenses/>.                       *
 ************************************************************/
#include <map>
#include <utility>
#include "misc/assert.h"
#include "unsat_core_private.h"
#include "pclause_triple_store.h"

namespace UnsatCore
{
  PClauseTripleStore::PClauseTripleStore()
    : myStore()
  { }

  PClauseTripleStore::~PClauseTripleStore()
  {
    Assert(myStore.empty(), "myStore not empty.");
  }

  void PClauseTripleStore::reset()
  {
    Assert(myStore.empty(), "myStore not empty.");
  }

  void PClauseTripleStore::storeTriple(PClause const & pc1,
                                       PClause const & pc2,
                                       PClause const & pc3)
  {
    Assert(myStore.find(pc1) == myStore.end(),
           "PClause already present in myStore.");
    myStore[pc1] = make_pair(pc2, pc3);
  }
  
  // Destructive.
  std::pair<PClause, PClause> PClauseTripleStore::getTriple(PClause const & pc)
  {
    Assert(myStore.find(pc) != myStore.end(),
           "PClause not present in myStore.");
    std::pair<PClause, PClause> result = myStore[pc];
    deleteTriple(pc);
    return result;
  }

  void PClauseTripleStore::deleteTriple(PClause const & pc)
  {
    Assert(myStore.find(pc) != myStore.end(),
           "PClause not present in myStore.");
    std::map<PClause, std::pair<PClause, PClause> >::iterator it = myStore.find(pc);
    myStore.erase(it);
  }
} // namespace UnsatCore
