/************************************************************
 *    Copyright (C) 2012                                    *
 *    Viktor Schuppan (Viktor.Schuppan@gmx.de)              *
 *                                                          *
 *    This program is free software; you can redistribute   *
 *    it and/or modify it under the terms of the GNU        *
 *    General Public License as published by the Free       *
 *    Software Foundation, either version 3 of the License, *
 *    or (at your option) any later version.                *
 *                                                          *
 *    This program is distributed in the hope that it will  *
 *    be useful, but WITHOUT ANY WARRANTY; without even     *
 *    the implied warranty of MERCHANTABILITY or FITNESS    *
 *    FOR A PARTICULAR PURPOSE.  See the GNU General Public *
 *    License for more details.                             *
 *                                                          *
 *    You should have received a copy of the GNU General    *
 *    Public License along with this program.  If not, see  *
 *    <http://www.gnu.org/licenses/>.                       *
 ************************************************************/
#ifndef __PCLAUSE_TRIPLE_STORE_H__
#define __PCLAUSE_TRIPLE_STORE_H__

#include <map>
#include <utility>
#include "unsat_core_private.h"

namespace UnsatCore
{
  class PClauseTripleStore
  {
  private:
    std::map<PClause, std::pair<PClause, PClause> > myStore;
  public:
    PClauseTripleStore();
    ~PClauseTripleStore();
    void reset();
    void storeTriple(PClause const & pc1,
                     PClause const & pc2,
                     PClause const & pc3);
    std::pair<PClause, PClause> getTriple(PClause const & pc);
    void deleteTriple(PClause const & pc);
  }; // class PClauseTripleStore
} // namespace UnsatCore
#endif // __PCLAUSE_TRIPLE_STORE_H__
