/************************************************************
 *    Copyright (C) 2012                                    *
 *    Viktor Schuppan (Viktor.Schuppan@gmx.de)              *
 *                                                          *
 *    This program is free software; you can redistribute   *
 *    it and/or modify it under the terms of the GNU        *
 *    General Public License as published by the Free       *
 *    Software Foundation, either version 3 of the License, *
 *    or (at your option) any later version.                *
 *                                                          *
 *    This program is distributed in the hope that it will  *
 *    be useful, but WITHOUT ANY WARRANTY; without even     *
 *    the implied warranty of MERCHANTABILITY or FITNESS    *
 *    FOR A PARTICULAR PURPOSE.  See the GNU General Public *
 *    License for more details.                             *
 *                                                          *
 *    You should have received a copy of the GNU General    *
 *    Public License along with this program.  If not, see  *
 *    <http://www.gnu.org/licenses/>.                       *
 ************************************************************/
#ifndef __UNSAT_CORE_PRIVATE_H__
#define __UNSAT_CORE_PRIVATE_H__

#include <limits>
#include "adaptor/iclause.h"
#include "adaptor/uclause.h"
#include "adaptor/sclause.h"
#include "stl_tim/attribute.h"
#include "stl_tim/literal.h"
#include "stl_tim/pclause.h"
#include "trim/eclause.h"

namespace UnsatCore
{
  typedef Adaptors::IClause IClause;
  typedef Adaptors::UClause UClause;
  typedef Adaptors::SClause SClause;
  typedef TRIMs::EClause EClause;
  typedef PropositionalProver::PClause PClause;
  typedef unsigned int Partition;
  Partition const mainPartition = 0;
  Partition const invalidPartition = std::numeric_limits<Partition>::max();
} // namespace UnsatCore
#endif // __UNSAT_CORE_PRIVATE_H__
