/************************************************************
 *    Copyright (C) 2012                                    *
 *    Viktor Schuppan (Viktor.Schuppan@gmx.de)              *
 *                                                          *
 *    This program is free software; you can redistribute   *
 *    it and/or modify it under the terms of the GNU        *
 *    General Public License as published by the Free       *
 *    Software Foundation, either version 3 of the License, *
 *    or (at your option) any later version.                *
 *                                                          *
 *    This program is distributed in the hope that it will  *
 *    be useful, but WITHOUT ANY WARRANTY; without even     *
 *    the implied warranty of MERCHANTABILITY or FITNESS    *
 *    FOR A PARTICULAR PURPOSE.  See the GNU General Public *
 *    License for more details.                             *
 *                                                          *
 *    You should have received a copy of the GNU General    *
 *    Public License along with this program.  If not, see  *
 *    <http://www.gnu.org/licenses/>.                       *
 ************************************************************/
#ifndef __UNSAT_CORE_WRITER_H__
#define __UNSAT_CORE_WRITER_H__

#include <iostream>
#include <map>
#include "builder_ltl/formula.h"
#include "getopt/options.h"
#include "stl_tim/literal.h"
#include "clause_handle.h"
#include "semi_linear_set.h"
#include "unsat_core_private.h"

namespace UnsatCore
{
  class UnsatCoreWriter
  {
  private:
    std::string myNvvVarPrefix;
  public:
    UnsatCoreWriter();
    std::ostream & dumpClausehs(std::ostream & os,
                                ClauseHandleSet const & chs,
                                std::map<ClauseHandle, SemiLinearSet> & mChToSls,
                                std::list<TreeNode*> const & formulaList,
                                std::map<TreeNode*, SemiLinearSet> & mSfToSls,
                                TRPPPOptions options);
    std::ostream & dumpClausehsSimpleInternal(std::ostream & os,
                                              ClauseHandleSet const & chs);
    std::ostream & dumpClausehsSimpleSNF(std::ostream & os,
                                         ClauseHandleSet const & chs);
    std::ostream & dumpClausehsSimpleLTLC(std::ostream & os,
                                          ClauseHandleSet const & chs);
    std::ostream & dumpClausehsSimpleLTL(std::ostream & os,
                                       std::list<TreeNode*> const & formulaList);
    std::ostream & dumpClausehsPositionSetsInternal(std::ostream & os,
                                                    ClauseHandleSet const & chs,
                               std::map<ClauseHandle, SemiLinearSet> & mChToSls);
    std::ostream & dumpClausehsPositionSetsSNF(std::ostream & os,
                                               ClauseHandleSet const & chs,
                               std::map<ClauseHandle, SemiLinearSet> & mChToSls);
    std::ostream & dumpClausehsPositionSetsLTLC(std::ostream & os,
                                                ClauseHandleSet const & chs,
                               std::map<ClauseHandle, SemiLinearSet> & mChToSls);
    std::ostream & dumpClausehsPositionSetsLTL(std::ostream & os,
                                               ClauseHandleSet const & chs,
                                std::map<ClauseHandle, SemiLinearSet> & mChToSls,
                                        std::list<TreeNode*> const & formulaList,
                                  std::map<TreeNode*, SemiLinearSet> & mSfToSls);

  private:
    std::ostream & dump_literal(std::ostream & os,
                                PropositionalProver::Literal const & l);
    std::ostream & dump_clauseh_SNF(std::ostream & os, ClauseHandle const & ch);
    std::ostream & dump_clauseh_body_LTLC(std::ostream & os,
                                          ClauseHandle const & ch);
    std::ostream & dump_clauseh_LTLC(std::ostream & os, ClauseHandle const & ch);
    std::ostream & dump_clausehs_simple_LTL_rec(std::ostream & os,
                                                TreeNode * n,
                                                bool isPositivePolarity);
    std::ostream & dump_clausehs_position_sets_LTL_rec(std::ostream & os,
                                                       TreeNode * n,
                                                       bool isPositivePolarity,
                                  std::map<TreeNode*, SemiLinearSet> & mSfToSls);
    std::string get_unused_var_prefix(ClauseHandleSet const & chs,
                                      std::string const & startPrefix);
  }; // classUnsatCoreWriter
} // namespace UnsatCore
#endif // __UNSAT_CORE_WRITER_H__
