/**************************************************************/
/* ********************************************************** */
/* *                                                        * */
/* *  Copyright (C) 2001-2011                               * */
/* *  Boris Konev                                           * */
/* *  The University of Liverpool                           * */
/* *                                                        * */
/* *  Copyright (C) 2012-2013                               * */
/* *  Viktor Schuppan                                       * */
/* *                                                        * */
/* *  This program is free software; you can redistribute   * */
/* *  it and/or modify it under the terms of the GNU        * */
/* *  General Public License as published by the Free       * */
/* *  Software Foundation; either version 2 of the License, * */
/* *  or (at your option) any later version.                * */
/* *                                                        * */
/* *  This program is distributed in the hope that it will  * */
/* *  be useful, but WITHOUT ANY WARRANTY; without even     * */
/* *  the implied warranty of MERCHANTABILITY or FITNESS    * */
/* *  FOR A PARTICULAR PURPOSE.  See the GNU General Public * */
/* *  License for more details.                             * */
/* *                                                        * */
/* *  You should have received a copy of the GNU General    * */
/* *  Public License along with this program; if not, write * */
/* *  to the Free Software Foundation, Inc., 59 Temple      * */
/* *  Place, Suite 330, Boston, MA  02111-1307  USA         * */
/* *                                                        * */
/* *                                                        * */
/* ********************************************************** */
/**************************************************************/
#ifndef __ECLAUSE_H__
#define __ECLAUSE_H__

#include <functional>
#include <string>
#include <iostream>
#include "stl_tim/literal.h"
#include "adaptor/uclause.h"

namespace TRIMs
{
  // added value
  // EClause: E:(literal, literal,..., sometime(literal))
  // (Note that for now (forever?) there is only one literal under
  // sometime)
  class EClause
  {
  public:
    typedef PropositionalProver::Literal Literal;
    typedef Adaptors::UClause UClause;
    // we represent an eventuality clause as a pairs of
    // a literal and a universal clause (why not? ;-) )
  private:
    Literal l;
    UClause c;
  public:
    typedef UClause::const_iterator const_present_iterator;
    typedef const Literal* const_sometime_iterator;
#if 0
    // bug: neither Literal nor UClause have the required constructors
  EClause()
    : l(), c()
      { }
#endif
  EClause(const EClause& _ec)
    : l(_ec.l), c(_ec.c)
      {}
  EClause(const UClause& _uc, const Literal &_l)
    : l(_l), c(_uc)
    { }
  public:
    // members access
    const_present_iterator
      present_begin() const
    {
      return c.begin();
    }
    const_present_iterator
      present_end() const
    {
      return c.end();
    }
    const_sometime_iterator
      sometime_begin() const
    {
      return &l;
    }
    const_sometime_iterator
      sometime_end() const
    {
      const_sometime_iterator result = &l;
      result++;
      return result;
    }
    const Literal&
      getEventuality() const
    {
      return l;
    }
    const UClause&
      getC() const
    {
      return c;
    }
    const std::string&
      getInfo() const
    {
      return c.getInfo();
    }

    // simple output
    std::ostream&
      dump(std::ostream& os) const
      {
        os << "E:(";
        for (const_present_iterator p = this->present_begin();
             p != this->present_end();
             ++p)
          {
            p->dump(os);
            os << " ";
          }
        os << ", Sometime(";
        l.dump(os);
        os << ") )" << std::endl;
        return os;
      }

    bool
      operator<(EClause const & other) const
    {
      // lexical comparison with higher priority to eventuality literal
      if (l < other.l)
        return true;
      else if (other.l < l)
        return false;
      else
        return c.getInternalRep() < other.c.getInternalRep();
    }
  };
} // namespace TRIMs

namespace std
{
  template <>
    class hash<TRIMs::EClause>
    {
    public :
      size_t operator()(const TRIMs::EClause & ec) const
      {
        return hash<PropositionalProver::Literal>()(ec.getEventuality()) ^
          hash<Adaptors::UClause>()(ec.getC());
      }
    };
};
#endif // __ECLAUSE_H__
