/************************************************************
 *    Copyright (C) 2013                                    *
 *    Viktor Schuppan (Viktor.Schuppan@gmx.de)              *
 *                                                          *
 *    This program is free software; you can redistribute   *
 *    it and/or modify it under the terms of the GNU        *
 *    General Public License as published by the Free       *
 *    Software Foundation, either version 3 of the License, *
 *    or (at your option) any later version.                *
 *                                                          *
 *    This program is distributed in the hope that it will  *
 *    be useful, but WITHOUT ANY WARRANTY; without even     *
 *    the implied warranty of MERCHANTABILITY or FITNESS    *
 *    FOR A PARTICULAR PURPOSE.  See the GNU General Public *
 *    License for more details.                             *
 *                                                          *
 *    You should have received a copy of the GNU General    *
 *    Public License along with this program.  If not, see  *
 *    <http://www.gnu.org/licenses/>.                       *
 ************************************************************/
#include <iostream>
#include "misc/assert.h"
#include "inference_rule_edge_labeling.h"

namespace UnsatCore
{
  std::ostream & dumpInferenceRuleEdgeLabeling(std::ostream & os,
                                          InferenceRuleEdgeLabeling const label)
  {
    switch (label) {
    case INFERENCE_RULE_EDGE_LABELING_INIT_II:
      os << "init-ii";
      break;
    case INFERENCE_RULE_EDGE_LABELING_INIT_INI:
      os << "init-ini";
      break;
    case INFERENCE_RULE_EDGE_LABELING_INIT_INN:
      os << "init-inn";
      break;
    case INFERENCE_RULE_EDGE_LABELING_STEP_NN:
      os << "step-nn";
      break;
    case INFERENCE_RULE_EDGE_LABELING_STEP_NXN:
      os << "step-nxn";
      break;
    case INFERENCE_RULE_EDGE_LABELING_STEP_NXX:
      os << "step-nxx";
      break;
    case INFERENCE_RULE_EDGE_LABELING_STEP_XX:
      os << "step-xx";
      break;
    case INFERENCE_RULE_EDGE_LABELING_AUG1:
      os << "aug1";
      break;
    case INFERENCE_RULE_EDGE_LABELING_AUG2:
      os << "aug2";
      break;
    case INFERENCE_RULE_EDGE_LABELING_BFS_LOOP_IT_INIT_X:
      os << "BFS-loop-it-init-x";
      break;
    case INFERENCE_RULE_EDGE_LABELING_BFS_LOOP_IT_INIT_N:
      os << "BFS-loop-it-init-n";
      break;
    case INFERENCE_RULE_EDGE_LABELING_BFS_LOOP_IT_INIT_CG:
      os << "BFS-loop-it-init-cg";
      break;
    case INFERENCE_RULE_EDGE_LABELING_BFS_LOOP_IT_INIT_CE:
      os << "BFS-loop-it-init-ce";
      break;
    case INFERENCE_RULE_EDGE_LABELING_BFS_LOOP_IT_SUB:
      os << "BFS-loop-it-sub";
      break;
    case INFERENCE_RULE_EDGE_LABELING_BFS_LOOP_CONCLUSION1_WEMPTYG:
      os << "BFS-loop-conclusion1-wemptyg";
      break;
    case INFERENCE_RULE_EDGE_LABELING_BFS_LOOP_CONCLUSION1_WEMPTYE:
      os << "BFS-loop-conclusion1-wemptye";
      break;
    case INFERENCE_RULE_EDGE_LABELING_BFS_LOOP_CONCLUSION2_WEMPTYG:
      os << "BFS-loop-conclusion2-wemptyg";
      break;
    case INFERENCE_RULE_EDGE_LABELING_BFS_LOOP_CONCLUSION2_WEMPTYE:
      os << "BFS-loop-conclusion2-wemptye";
      break;
    case INFERENCE_RULE_EDGE_LABELING_BFS_LOOP_CONCLUSION1_WOEMPTYG:
      os << "BFS-loop-conclusion1-woemptyg";
      break;
    case INFERENCE_RULE_EDGE_LABELING_BFS_LOOP_CONCLUSION1_WOEMPTYE:
      os << "BFS-loop-conclusion1-woemptye";
      break;
    case INFERENCE_RULE_EDGE_LABELING_BFS_LOOP_CONCLUSION2_WOEMPTYG :
      os << "BFS-loop-conclusion2-woemptyg";
      break;
    case INFERENCE_RULE_EDGE_LABELING_BFS_LOOP_CONCLUSION2_WOEMPTYE :
      os << "BFS-loop-conclusion2-woemptye";
      break;
    default:
      Assert(false, "Unexpected label.");
    }
    return os;
  } // dumpInferenceRuleEdgeLabeling
} // namespace UnsatCore
