/************************************************************
 *    Copyright (C) 2013                                    *
 *    Viktor Schuppan (Viktor.Schuppan@gmx.de)              *
 *                                                          *
 *    This program is free software; you can redistribute   *
 *    it and/or modify it under the terms of the GNU        *
 *    General Public License as published by the Free       *
 *    Software Foundation, either version 3 of the License, *
 *    or (at your option) any later version.                *
 *                                                          *
 *    This program is distributed in the hope that it will  *
 *    be useful, but WITHOUT ANY WARRANTY; without even     *
 *    the implied warranty of MERCHANTABILITY or FITNESS    *
 *    FOR A PARTICULAR PURPOSE.  See the GNU General Public *
 *    License for more details.                             *
 *                                                          *
 *    You should have received a copy of the GNU General    *
 *    Public License along with this program.  If not, see  *
 *    <http://www.gnu.org/licenses/>.                       *
 ************************************************************/
#ifndef __INFERENCE_RULE_EDGE_LABELING_H__
#define __INFERENCE_RULE_EDGE_LABELING_H__

#include <iostream>

namespace UnsatCore
{
  typedef enum { INFERENCE_RULE_EDGE_LABELING_INIT_II,
                 INFERENCE_RULE_EDGE_LABELING_INIT_INI,
                 INFERENCE_RULE_EDGE_LABELING_INIT_INN,
                 INFERENCE_RULE_EDGE_LABELING_STEP_NN,
                 INFERENCE_RULE_EDGE_LABELING_STEP_NXN,
                 INFERENCE_RULE_EDGE_LABELING_STEP_NXX,
                 INFERENCE_RULE_EDGE_LABELING_STEP_XX,
                 INFERENCE_RULE_EDGE_LABELING_AUG1,
                 INFERENCE_RULE_EDGE_LABELING_AUG2,
                 INFERENCE_RULE_EDGE_LABELING_BFS_LOOP_IT_INIT_X,
                 INFERENCE_RULE_EDGE_LABELING_BFS_LOOP_IT_INIT_N,
                 INFERENCE_RULE_EDGE_LABELING_BFS_LOOP_IT_INIT_CG,
                 INFERENCE_RULE_EDGE_LABELING_BFS_LOOP_IT_INIT_CE,
                 INFERENCE_RULE_EDGE_LABELING_BFS_LOOP_IT_SUB,
                 INFERENCE_RULE_EDGE_LABELING_BFS_LOOP_CONCLUSION1_WEMPTYG,
                 INFERENCE_RULE_EDGE_LABELING_BFS_LOOP_CONCLUSION1_WEMPTYE,
                 INFERENCE_RULE_EDGE_LABELING_BFS_LOOP_CONCLUSION2_WEMPTYG,
                 INFERENCE_RULE_EDGE_LABELING_BFS_LOOP_CONCLUSION2_WEMPTYE,
                 INFERENCE_RULE_EDGE_LABELING_BFS_LOOP_CONCLUSION1_WOEMPTYG,
                 INFERENCE_RULE_EDGE_LABELING_BFS_LOOP_CONCLUSION1_WOEMPTYE,
                 INFERENCE_RULE_EDGE_LABELING_BFS_LOOP_CONCLUSION2_WOEMPTYG,
                 INFERENCE_RULE_EDGE_LABELING_BFS_LOOP_CONCLUSION2_WOEMPTYE }
  InferenceRuleEdgeLabeling;

  std::ostream & dumpInferenceRuleEdgeLabeling(std::ostream & os,
                                         InferenceRuleEdgeLabeling const label);
} // namespace UnsatCore
#endif // __INFERENCE_RULE_EDGE_LABELING_H__
