/************************************************************
 *    Copyright (C) 2012-2014                               *
 *    Viktor Schuppan (Viktor.Schuppan@gmx.de)              *
 *                                                          *
 *    This program is free software; you can redistribute   *
 *    it and/or modify it under the terms of the GNU        *
 *    General Public License as published by the Free       *
 *    Software Foundation, either version 3 of the License, *
 *    or (at your option) any later version.                *
 *                                                          *
 *    This program is distributed in the hope that it will  *
 *    be useful, but WITHOUT ANY WARRANTY; without even     *
 *    the implied warranty of MERCHANTABILITY or FITNESS    *
 *    FOR A PARTICULAR PURPOSE.  See the GNU General Public *
 *    License for more details.                             *
 *                                                          *
 *    You should have received a copy of the GNU General    *
 *    Public License along with this program.  If not, see  *
 *    <http://www.gnu.org/licenses/>.                       *
 ************************************************************/
#ifndef __BUILDER_LTL_H__
#define __BUILDER_LTL_H__

#include <map>
#include "formula.h"
#include "getopt/options.h"
#include "unsat_core/clause_handle.h"
#include "unsat_core/literal_clauseh_occurrence.h"

namespace BuilderLtl
{
  class BuilderLtl
  {
  public:
    static TreeNodeList parseLtl(TRPPPOptions const & options);
    static void replaceEquivalencesLtl(TreeNodeList & formulaList);
    static void nnfLtl(TreeNodeList & formulaList);
    static void simplifyLtl(TreeNodeList & formulaList,
                            TRPPPOptions const & options);
    static void translateLtlToSnf(TreeNodeList & formulaList,
                                  UnsatCore::ClauseHandleSet & clausehSet,
                   std::map<TreeNode*, UnsatCore::LiteralClausehOccurrenceSet> &
                                  mapSubformulaToUseLCHOsNow,
                   std::map<TreeNode*, UnsatCore::LiteralClausehOccurrenceSet> &
                                  mapSubformulaToUseLCHOsNext,
                   std::map<TreeNode*, UnsatCore::LiteralClausehOccurrenceSet> &
                                  mapSubformulaToUseLCHOsSometime,
                                  UnsatCore::LiteralClausehOccurrenceSet &
                                  setSubformulaToUseLCHOsInvalidPos,
                                  TRPPPOptions const & options);
    static void simplifySnf(UnsatCore::ClauseHandleSet & clausehSet);
    static void checkSnfForEmptyClause(UnsatCore::ClauseHandleSet const &
                                       clausehSet);
  }; // class BuilderLtl
} // namespace BuilderLtl
#endif // __BUILDER_LTL_H__
