/************************************************************
 *    Copyright (C) 2008-2009                               *
 *    Michel Ludwig (michel.ludwig@liverpool.ac.uk)         *
 *    University of Liverpool                               *
 *                                                          *
 *    Copyright (C) 2012                                    *
 *    Viktor Schuppan (Viktor.Schuppan@gmx.de)              *
 *                                                          *
 *    This program is free software; you can redistribute   *
 *    it and/or modify it under the terms of the GNU        *
 *    General Public License as published by the Free       *
 *    Software Foundation; either version 3 of the License, *
 *    or (at your option) any later version.                *
 *                                                          *
 *    This program is distributed in the hope that it will  *
 *    be useful, but WITHOUT ANY WARRANTY; without even     *
 *    the implied warranty of MERCHANTABILITY or FITNESS    *
 *    FOR A PARTICULAR PURPOSE.  See the GNU General Public *
 *    License for more details.                             *
 *                                                          *
 *    You should have received a copy of the GNU General    *
 *    Public License along with this program; if not, see   *
 *    <http://www.gnu.org/licenses/>.                       *
 ************************************************************/
 
%{

#include <iostream>

#include "builder_ltl/formula.h"
#include "builder_ltl/helpers.h"

extern "C"
{
  void trpltl_yyerror(const char*);
}
int trpltl_yylex(void);

extern list *formula_list;

%}

%error-verbose

%token ID
%token LEFT_BRACKET
%token RIGHT_BRACKET
%token NOT
%token AND
%token OR
%token IMPLICATION
%token EQUIVALENCE
%token ALWAYS
%token SOMETIME
%token NEXT
%token UNTIL
%token TRUE
%token FALSE
%token UNLESS

%union {
  char* cstring;
  struct tree* ctree;
  struct list* clist;
}

%left UNTIL
%left UNLESS
%left EQUIVALENCE
%left OR
%left IMPLICATION
%left AND
%left NOT
%left SOMETIME
%left ALWAYS
%left NEXT

%start start

%type <clist> start
%type <ctree> formula connective
%type <cstring> ID

%%

start:          formula
                {
                  $$ = list_List($1);
                  formula_list = $$;
                }

formula:        ID
                {
                  $$ = tree_TreeId($1);
                }
        |
                connective
                {
                  $$ = $1;
                }
                ;

connective:     TRUE
                {
                  $$ = tree_TreeOp(TRUE);
                }
        |
                FALSE
                {
                  $$ = tree_TreeOp(FALSE);
                }
        |
                NOT formula
		{
                  tree *t = tree_TreeOp(NOT);
                  tree_SetChildren(t, list_List($2));
                  $$ = t;
		}
        |
                formula AND formula
		{
                  tree *t = tree_TreeOp(AND);
                  tree_SetChildren(t, list_PushBack(list_List($1), $3));
                  $$ = t;
		}
        |
                formula OR formula
		{
                  tree *t = tree_TreeOp(OR);
                  tree_SetChildren(t, list_PushBack(list_List($1), $3));
                  $$ = t;
		}
        |
                formula IMPLICATION formula
		{
                  tree *t = tree_TreeOp(IMPLICATION);
                  tree_SetChildren(t, list_PushBack(list_List($1), $3));
                  $$ = t;
		}
        |
                formula EQUIVALENCE formula
		{
                  tree *t = tree_TreeOp(EQUIVALENCE);
                  tree_SetChildren(t, list_PushBack(list_List($1), $3));
                  $$ = t;
		}
	|
                ALWAYS formula
		{
                  tree *t = tree_TreeOp(ALWAYS);
                  tree_SetChildren(t, list_List($2));
                  $$ = t;
		}
	|
                SOMETIME formula
		{
                  tree *t = tree_TreeOp(SOMETIME);
                  tree_SetChildren(t, list_List($2));
                  $$ = t;
		}
	|
                NEXT formula
		{
                  tree *t = tree_TreeOp(NEXT);
                  tree_SetChildren(t, list_List($2));
                  $$ = t;
		}
	|
                formula UNTIL formula
		{
                  tree *t = tree_TreeOp(UNTIL);
                  tree_SetChildren(t, list_PushBack(list_List($1), $3));
                  $$ = t;
		}
	|
                formula UNLESS formula
		{
                  tree *t = tree_TreeOp(UNLESS);
                  tree_SetChildren(t, list_PushBack(list_List($1), $3));
                $$ = t;
		}
        |
                LEFT_BRACKET formula RIGHT_BRACKET
                {
                  $$ = $2;
                }
                ;

%%

list *formula_list = NULL;

void trpltl_yyerror(const char *error)
{
        std::cerr << "Error: " << error << std::endl;
        abort();
}
