/************************************************************
 *    Copyright (C) 2012                                    *
 *    Viktor Schuppan (Viktor.Schuppan@gmx.de)              *
 *                                                          *
 *    This program is free software; you can redistribute   *
 *    it and/or modify it under the terms of the GNU        *
 *    General Public License as published by the Free       *
 *    Software Foundation, either version 3 of the License, *
 *    or (at your option) any later version.                *
 *                                                          *
 *    This program is distributed in the hope that it will  *
 *    be useful, but WITHOUT ANY WARRANTY; without even     *
 *    the implied warranty of MERCHANTABILITY or FITNESS    *
 *    FOR A PARTICULAR PURPOSE.  See the GNU General Public *
 *    License for more details.                             *
 *                                                          *
 *    You should have received a copy of the GNU General    *
 *    Public License along with this program.  If not, see  *
 *    <http://www.gnu.org/licenses/>.                       *
 ************************************************************/
#ifndef __BFS_REACHABLES_RECORDER_H__
#define __BFS_REACHABLES_RECORDER_H__

#include <boost/graph/breadth_first_search.hpp>
#include <boost/tuple/tuple.hpp>
#include "misc/assert.h"
#include "unsat_core_private.h"

namespace UnsatCore
{
  // Visitor that puts vertex into reachable upon discovery
  //
  // Partly based on boost example "bfs-name-printer.cpp"
  template <typename VertexSet> class BfsReachablesRecorder:
  public boost::default_bfs_visitor
    {
    public:
    BfsReachablesRecorder(VertexSet * reachable)
      : myReachable(reachable)
      {
        Assert(reachable != (VertexSet *) NULL, "reachable is NULL.");
      } // BfsReachablesRecorder

      template <typename Vertex, typename Graph>
        void discover_vertex(Vertex v, Graph const &) const
      {
        Assert(myReachable != (VertexSet *) NULL, "myReachable is NULL.");

        // Insert v into *myReachable
        bool inserted;
        typename VertexSet::iterator dummy;
        boost::tie(dummy, inserted) = myReachable->insert(v);
        Assert(inserted, "v already present in myReachable.");
      } // discover_vertex
    private:
      VertexSet * myReachable;
    }; // class BfsReachablesRecorder
} // namespace UnsatCore
#endif // __BFS_REACHABLES_RECORDER_H__
