/************************************************************
 *    Copyright (C) 2014                                    *
 *    Viktor Schuppan (Viktor.Schuppan@gmx.de)              *
 *                                                          *
 *    This program is free software; you can redistribute   *
 *    it and/or modify it under the terms of the GNU        *
 *    General Public License as published by the Free       *
 *    Software Foundation, either version 3 of the License, *
 *    or (at your option) any later version.                *
 *                                                          *
 *    This program is distributed in the hope that it will  *
 *    be useful, but WITHOUT ANY WARRANTY; without even     *
 *    the implied warranty of MERCHANTABILITY or FITNESS    *
 *    FOR A PARTICULAR PURPOSE.  See the GNU General Public *
 *    License for more details.                             *
 *                                                          *
 *    You should have received a copy of the GNU General    *
 *    Public License along with this program.  If not, see  *
 *    <http://www.gnu.org/licenses/>.                       *
 ************************************************************/
#include <iostream>
#include <limits>
#include <string>
#include "misc/assert.h"
#include "unsat_core_private.h"
#include "lcho_partition.h"

namespace UnsatCore
{
  unsigned long LCHOPartition::nextId = 0;

  Proposition const LCHOPartition::invalidP =
    Proposition(std::string("invalid"));

  LCHOPartition::LCHOPartition()
    : myId(nextId), myP(invalidP)
  {
    Assert(nextId < std::numeric_limits<unsigned long>::max(),
           "nextId >= std::numeric_limits<unsigned long>::max().");
    nextId++;
  } // LCHOPartition::LCHOPartition

  LCHOPartition::LCHOPartition(Proposition const & p)
    : myId(nextId), myP(p)
  {
    Assert(nextId < std::numeric_limits<unsigned long>::max(),
           "nextId >= std::numeric_limits<unsigned long>::max().");
    nextId++;
  } // LCHOPartition::LCHOPartition

  Proposition LCHOPartition::getP() const
  {
    return myP;
  } // LCHOPartition::getP

  std::ostream &
  LCHOPartition::dump(std::ostream & os) const
  {
    os << "(";
    myP.dump(os);
    os << ", " << myId << ")";
    return os;
  } // LCHOPartition::dump

  bool
  LCHOPartition::operator<
  (LCHOPartition const & other) const
  {
    if (myId < other.myId) {
      return true;
    } else if (other.myId < myId) {
      return false;
    } else {
      return myP < other.myP;
    }
  } // LCHOPartition::operator<

  bool
  LCHOPartition::operator==
  (LCHOPartition const & other) const
  {
    return myId == other.myId &&
      myP == other.myP;
  } // LCHOPartition::operator==

  bool
  LCHOPartition::operator!=
  (LCHOPartition const & other) const
  {
    return myId != other.myId ||
      myP != other.myP;
  } // LCHOPartition::operator!=
} // namespace UnsatCore
