/************************************************************
 *    Copyright (C) 2012-2014                               *
 *    Viktor Schuppan (Viktor.Schuppan@gmx.de)              *
 *                                                          *
 *    This program is free software; you can redistribute   *
 *    it and/or modify it under the terms of the GNU        *
 *    General Public License as published by the Free       *
 *    Software Foundation, either version 3 of the License, *
 *    or (at your option) any later version.                *
 *                                                          *
 *    This program is distributed in the hope that it will  *
 *    be useful, but WITHOUT ANY WARRANTY; without even     *
 *    the implied warranty of MERCHANTABILITY or FITNESS    *
 *    FOR A PARTICULAR PURPOSE.  See the GNU General Public *
 *    License for more details.                             *
 *                                                          *
 *    You should have received a copy of the GNU General    *
 *    Public License along with this program.  If not, see  *
 *    <http://www.gnu.org/licenses/>.                       *
 ************************************************************/
#ifndef __MAPPER_SNF_TO_LTL_H__
#define __MAPPER_SNF_TO_LTL_H__

#include <list>
#include <map>
#include <set>
#include "builder_ltl/formula.h"
#include "getopt/options.h"
#include "clause_handle.h"
#include "lcho_partition.h"
#include "lcho_partitioner.h"
#include "literal_clauseh_occurrence.h"
#include "semi_linear_set.h"
#include "unsat_core_private.h"

namespace UnsatCore
{
  class MapperSnfToLtl
  {
  public:
    static void computeCoreLtl(ClauseHandleSet const & coreStartingClausehs,
                               std::list<TreeNode*> & formulaList,
                              std::map<TreeNode*, LiteralClausehOccurrenceSet> &
                               mapSubformulaToUseLCHOsNow,
                              std::map<TreeNode*, LiteralClausehOccurrenceSet> &
                               mapSubformulaToUseLCHOsNext,
                              std::map<TreeNode*, LiteralClausehOccurrenceSet> &
                               mapSubformulaToUseLCHOsSometime,
                               LiteralClausehOccurrenceSet &
                               setSubformulaToUseLCHOsInvalidPos,
                               MapLCHOToLCHOPartition & mapLCHOToLCHOPartition,
                               std::map<LCHOPartition, unsigned long> &
                               mapLCHOPartitionToIndex,
                               std::map<ClauseHandle, SemiLinearSet> &
                               mapClausehToSemiLinearSet,
                               std::map<TreeNode*, SemiLinearSet> &
                               mapSubformulaToSemiLinearSet,
                               TRPPPOptions const & options);
    static void simplifyCoreLtl(std::list<TreeNode*> & formulaList,
                                std::set<TreeNode*> & coreSimplifiedSubformulas,
                                TRPPPOptions const & options);
  private:
    ClauseHandleSet const & myCoreStartingClausehs;
    std::list<TreeNode*> & myFormulaList;
    std::map<TreeNode*, LiteralClausehOccurrenceSet> &
      myMapSubformulaToUseLCHOsNow;
    std::map<TreeNode*, LiteralClausehOccurrenceSet> &
      myMapSubformulaToUseLCHOsNext;
    std::map<TreeNode*, LiteralClausehOccurrenceSet> &
      myMapSubformulaToUseLCHOsSometime;
    LiteralClausehOccurrenceSet & mySetSubformulaToUseLCHOsInvalidPos;
    MapLCHOToLCHOPartition & myMapLCHOToLCHOPartition;
    std::map<LCHOPartition, unsigned long> & myMapLCHOPartitionToIndex;
    std::map<ClauseHandle, SemiLinearSet> & myMapClausehToSemiLinearSet;
    std::map<TreeNode*, SemiLinearSet> & myMapSubformulaToSemiLinearSet;
    std::map<LCHOPartition, Identifier *> myMapLCHOPartitionToIdentifier;
    std::map<Proposition, LCHOPartitionSet>
      myMapPropositionToLCHOPartitionSet;
    std::map<Proposition, LCHOPartitionSet>
      myMapNVVPropositionToLCHOPartitionSet;
    TRPPPOptions const & myOptions;
    unsigned long myNoPropositionsLtlCore;
    unsigned long myNoPropositionOccurrencesLtlCore;
    unsigned long myNoPartitionsPerPropositionPeakLtlCore;
    unsigned long myNoPartitionsPerPropositionGE2LtlCore;
  private:
    MapperSnfToLtl(ClauseHandleSet const & coreStartingClausehs,
                   std::list<TreeNode*> & formulaList,
                   std::map<TreeNode*, LiteralClausehOccurrenceSet> &
                   mapSubformulaToUseLCHOsNow,
                   std::map<TreeNode*, LiteralClausehOccurrenceSet> &
                   mapSubformulaToUseLCHOsNext,
                   std::map<TreeNode*, LiteralClausehOccurrenceSet> &
                   mapSubformulaToUseLCHOsSometime,
                   LiteralClausehOccurrenceSet &
                   setSubformulaToUseLCHOsInvalidPos,
                   MapLCHOToLCHOPartition & mapLCHOToLCHOPartition,
                   std::map<LCHOPartition, unsigned long> &
                   mapLCHOPartitionToIndex,
                   std::map<ClauseHandle, SemiLinearSet> &
                   mapClausehToSemiLinearSet,
                   std::map<TreeNode*, SemiLinearSet> &
                   mapSubformulaToSemiLinearSet,
                   TRPPPOptions const & options);
    ~MapperSnfToLtl();
    void compute_core_ltl();
    TreeNode * compute_core_simple_ltl_rec(TreeNode * n,
                                           bool isPositivePolarity,
                               std::set<TreeNode*> & coreSimplifiedSubformulas);
    TreeNode * compute_core_sets_of_time_points_ltl_rec(TreeNode * n,
                                                        bool isPositivePolarity,
                               std::set<TreeNode*> & coreSimplifiedSubformulas);
    void compute_core_partitioned_ltl_prepare();
    void compute_core_partitioned_ltl_prepare_uf_make_set(
                             LCHOPartitioner::LCHOPartitionDisjointSets & ufind,
                                                          TreeNode * n);
    void compute_core_partitioned_ltl_prepare_uf_union_set(
                             LCHOPartitioner::LCHOPartitionDisjointSets & ufind,
                                                          TreeNode * n);
    void compute_core_partitioned_ltl_prepare_uf_find_set(
                             LCHOPartitioner::LCHOPartitionDisjointSets & ufind,
                                                          TreeNode * n);
    bool has_uses_uc(TreeNode * n);
    bool has_valid_uses_uc(TreeNode * n);
    LiteralClausehOccurrenceSet get_valid_uses_uc(TreeNode * n);
    std::ostream &
      dump_maps_sets_subformula_to_use_lchos(std::ostream & os) const;
    std::ostream & dump_myMapLCHOToLCHOPartition(std::ostream & os) const;
  private:
    static TreeNode * simplify_core_ltl_rec(TreeNode * n,
                                            bool isPositivePolarity,
                               std::set<TreeNode*> & coreSimplifiedSubformulas);
    static void erase_tn_from_set_rec(TreeNode * n, std::set<TreeNode*> & s);
  }; // class MapperSnfToLtl
} // namespace UnsatCore
#endif // __MAPPER_SNF_TO_LTL_H__
