/************************************************************
 *    Copyright (C) 2012-2013                               *
 *    Viktor Schuppan (Viktor.Schuppan@gmx.de)              *
 *                                                          *
 *    This program is free software; you can redistribute   *
 *    it and/or modify it under the terms of the GNU        *
 *    General Public License as published by the Free       *
 *    Software Foundation, either version 3 of the License, *
 *    or (at your option) any later version.                *
 *                                                          *
 *    This program is distributed in the hope that it will  *
 *    be useful, but WITHOUT ANY WARRANTY; without even     *
 *    the implied warranty of MERCHANTABILITY or FITNESS    *
 *    FOR A PARTICULAR PURPOSE.  See the GNU General Public *
 *    License for more details.                             *
 *                                                          *
 *    You should have received a copy of the GNU General    *
 *    Public License along with this program.  If not, see  *
 *    <http://www.gnu.org/licenses/>.                       *
 ************************************************************/
#ifndef __PCLAUSE_RESOLUTION_MAP_H__
#define __PCLAUSE_RESOLUTION_MAP_H__

#include <unordered_map>
#include "unsat_core_private.h"

namespace UnsatCore
{
  class PClauseResolutionMap
  {
  private:
    std::unordered_map<PClause, PClause> myMap;
  public:
    PClauseResolutionMap();
    ~PClauseResolutionMap();
    void reset();
    void store(PClause const & pc1, PClause const & pc2);
    PClause get(PClause const & pc);
    void erase(PClause const & pc);
  }; // class PClauseResolutionMap
} // namespace UnsatCore
#endif // __PCLAUSE_RESOLUTION_MAP_H__
