/************************************************************
 *    Copyright (C) 2012-2013                               *
 *    Viktor Schuppan (Viktor.Schuppan@gmx.de)              *
 *                                                          *
 *    This program is free software; you can redistribute   *
 *    it and/or modify it under the terms of the GNU        *
 *    General Public License as published by the Free       *
 *    Software Foundation, either version 3 of the License, *
 *    or (at your option) any later version.                *
 *                                                          *
 *    This program is distributed in the hope that it will  *
 *    be useful, but WITHOUT ANY WARRANTY; without even     *
 *    the implied warranty of MERCHANTABILITY or FITNESS    *
 *    FOR A PARTICULAR PURPOSE.  See the GNU General Public *
 *    License for more details.                             *
 *                                                          *
 *    You should have received a copy of the GNU General    *
 *    Public License along with this program.  If not, see  *
 *    <http://www.gnu.org/licenses/>.                       *
 ************************************************************/
#ifndef __SIMPLIFIER_H__
#define __SIMPLIFIER_H__

#include <map>
#include <set>
#include "getopt/options.h"
#include "stl_tim/literal.h"
#include "stl_tim/proposition.h"
#include "unsat_core/clause_handle.h"
#include "formula.h"

namespace BuilderLtl
{
  // maps from positive/negative occurrences to the respective clausehs
  typedef std::map<PropositionalProver::Proposition, UnsatCore::ClauseHandleSet>
    MapPToChs;

  void simplifyFormulasLtl(TreeNodeList & formulaList,
                           TRPPPOptions const & options);
  TreeNode * simplifyFormulaLtl(TreeNode * n,
                                TRPPPOptions const & options);
  void replaceEquivalencesFormulasLtl(TreeNodeList & formulaList);
  void replaceEquivalencesFormulaLtl(TreeNode * n);
  void nnfFormulasLtl(TreeNodeList & formulaList);
  TreeNode * nnfFormulaLtl(TreeNode * n);
  void simplifyClausehsPureLiteral(UnsatCore::ClauseHandleSet & clausehs);

  TreeNode * simplify_formula_ltl_rec(TreeNode * n,
                                      bool isPositivePolarity,
                                      bool isInitial,
                                      TRPPPOptions const & options,
                                      bool & changed);
  void replace_equivalences_formula_ltl_rec(TreeNode * n);
  TreeNode * nnf_formula_ltl_rec(TreeNode * n, bool isPositivePolarity);
  void simplify_clausehs_pure_literal_fill
    (PropositionalProver::Literal const & l,
     UnsatCore::ClauseHandle const & ch,
     std::set<PropositionalProver::Proposition> & propositions,
     MapPToChs & mPosToChs,
     MapPToChs & mNegToChs);
  void simplify_clausehs_pure_literal_remove_clausehs
    (UnsatCore::ClauseHandleSet const chs,
     UnsatCore::ClauseHandleSet & clausehs,
     MapPToChs & mInitPosToChs,
     MapPToChs & mInitNegToChs,
     MapPToChs & mUnivNowEvPosToChs,
     MapPToChs & mUnivNowEvNegToChs,
     MapPToChs & mNextPosToChs,
     MapPToChs & mNextNegToChs);
  void simplify_clausehs_pure_literal_remove_clauseh_from_maps
    (UnsatCore::ClauseHandle const & ch,
     PropositionalProver::Literal const & l,
     MapPToChs & mPosToChs,
     MapPToChs & mNegToChs);
} // namespace BuilderLtl
#endif // __SIMPLIFIER_H__
