/************************************************************
 *    Copyright (C) 2012-2013                               *
 *    Viktor Schuppan (Viktor.Schuppan@gmx.de)              *
 *                                                          *
 *    This program is free software; you can redistribute   *
 *    it and/or modify it under the terms of the GNU        *
 *    General Public License as published by the Free       *
 *    Software Foundation, either version 3 of the License, *
 *    or (at your option) any later version.                *
 *                                                          *
 *    This program is distributed in the hope that it will  *
 *    be useful, but WITHOUT ANY WARRANTY; without even     *
 *    the implied warranty of MERCHANTABILITY or FITNESS    *
 *    FOR A PARTICULAR PURPOSE.  See the GNU General Public *
 *    License for more details.                             *
 *                                                          *
 *    You should have received a copy of the GNU General    *
 *    Public License along with this program.  If not, see  *
 *    <http://www.gnu.org/licenses/>.                       *
 ************************************************************/
#ifndef __TRP_LTL_PARSER_H__
#define __TRP_LTL_PARSER_H__

#include "formula.h"
#include "getopt/options.h"

namespace BuilderLtl
{
  class TrpLtlParser
  {
  public:
    TrpLtlParser(TRPPPOptions const & options);
    void parseLtl();
    TreeNodeList getLtlFormulaList();
  private:
    TreeNodeList myFormulaList;
    TRPPPOptions const & myOptions;
  }; // class TrpLtlParser
} // namespace BuilderLtl
#endif // __TRP_LTL_PARSER_H__
