/**************************************************************/
/* ********************************************************** */
/* *                                                        * */
/* *  Copyright (C) 2001-2011                               * */
/* *  Boris Konev                                           * */
/* *  The University of Liverpool                           * */
/* *                                                        * */
/* *  Copyright (C) 2012-2013                               * */
/* *  Viktor Schuppan                                       * */
/* *                                                        * */
/* *  This program is free software; you can redistribute   * */
/* *  it and/or modify it under the terms of the GNU        * */
/* *  General Public License as published by the Free       * */
/* *  Software Foundation; either version 2 of the License, * */
/* *  or (at your option) any later version.                * */
/* *                                                        * */
/* *  This program is distributed in the hope that it will  * */
/* *  be useful, but WITHOUT ANY WARRANTY; without even     * */
/* *  the implied warranty of MERCHANTABILITY or FITNESS    * */
/* *  FOR A PARTICULAR PURPOSE.  See the GNU General Public * */
/* *  License for more details.                             * */
/* *                                                        * */
/* *  You should have received a copy of the GNU General    * */
/* *  Public License along with this program; if not, write * */
/* *  to the Free Software Foundation, Inc., 59 Temple      * */
/* *  Place, Suite 330, Boston, MA  02111-1307  USA         * */
/* *                                                        * */
/* *                                                        * */
/* ********************************************************** */
/**************************************************************/
#ifndef __MAIN_AUX_H__
#define __MAIN_AUX_H__

#include <map>
#include <queue>
#include <set>
#include <utility>
#include "adaptor/stl_tim_adaptor.h"
#include "builder/builder.h"
#include "builder_ltl/formula.h"
#include "getopt/options.h"
#include "trim/trim.h"
#include "unsat_core/clause_handle.h"
#include "unsat_core/semi_linear_set.h"
#include "unsat_core/unsat_core_private.h"

class MainAux
{
 public:
  typedef TRIMs::TRIM<Adaptors::Adaptor> ClauseSet;
  typedef Builders::Builder<ClauseSet> Builder;
 public:
  MainAux(TRPPPOptions const & options);
  ~MainAux();
  int main();
 private:
  TreeNodeList myFormulaList;
  std::map<TreeNode*, UnsatCore::ClauseHandleSet> myMapSubformulaToClausehsNow;
  std::map<TreeNode*, UnsatCore::ClauseHandleSet> myMapSubformulaToClausehsNext;
  std::map<TreeNode*, UnsatCore::ClauseHandleSet>
    myMapSubformulaToClausehsSometime;
  std::map<TreeNode*, UnsatCore::SemiLinearSet> myMapSubformulaToSemiLinearSet;
  UnsatCore::ClauseHandleSet myClausehSet;
  UnsatCore::ClauseHandleSet myCoreClausehSet;
  std::map<UnsatCore::ClauseHandle, UnsatCore::SemiLinearSet>
    myMapClausehToSemiLinearSet;
  bool myUnsat;
  TRPPPOptions myOptions;
  std::priority_queue<std::pair<TreeNode*, bool> > mySubformulasPQ;
  std::set<std::pair<TreeNode*, bool> > myWasInSubformulasPQ;
  std::set<TreeNode*> myCoreSimplifiedSubformulas;
  unsigned long myNoVerticesSyntaxTreeBeforeLtlSimplification;
  unsigned long myNoVerticesSyntaxTreeAfterLtlSimplification;
  unsigned long myNoVerticesSyntaxTreeProofCore;
  unsigned long myNoVerticesSyntaxTreeDeletionCore;
  unsigned long myNoUCDeletionIterations;
  unsigned long myNoUCDeletionIterationsUnsat;
  unsigned long myNoUCDeletionIterationsSat;
 private:
  int parse_snf();
  void parse_ltl();
  void simplify_snf(UnsatCore::ClauseHandleSet & clauseHandleSet);
  void simplify_ltl(TreeNodeList & formulaList);
  void check_snf_for_empty_clause(UnsatCore::ClauseHandleSet const &
                                  clauseHandleSet);
  bool prove(UnsatCore::ClauseHandleSet const & clausehSet);
  bool prove_core_extraction(TRPPPOptions const & options);
  void dumpUnsat();
  ClauseSet clause_handle_set_2_clause_set(UnsatCore::ClauseHandleSet const &
                                           clauseHandleSet);
  UnsatCore::ClauseHandleSet clause_set_2_clause_handle_set(ClauseSet const &
                                                            clauseSet,
                                                    UnsatCore::Partition const &
                                                            partition);
  void enqueue_children(TreeNode * subformula, bool isPositivePolarity);
  void replace_occurrences(TreeNode * top,
                           bool topIsPositivePolarity,
                           TreeNode * sf,
                           bool sfIsPositivePolarity,
                           TreeNode * r,
                           std::map<TreeNode *, TreeNode *> & mapORToSf);
  bool has_been_enqueued(TreeNode * f, bool isPositivePolarity);
};
#endif // __MAIN_AUX_H
