/************************************************************
 *    Copyright (C) 2012-2013                               *
 *    Viktor Schuppan (Viktor.Schuppan@gmx.de)              *
 *                                                          *
 *    This program is free software; you can redistribute   *
 *    it and/or modify it under the terms of the GNU        *
 *    General Public License as published by the Free       *
 *    Software Foundation, either version 3 of the License, *
 *    or (at your option) any later version.                *
 *                                                          *
 *    This program is distributed in the hope that it will  *
 *    be useful, but WITHOUT ANY WARRANTY; without even     *
 *    the implied warranty of MERCHANTABILITY or FITNESS    *
 *    FOR A PARTICULAR PURPOSE.  See the GNU General Public *
 *    License for more details.                             *
 *                                                          *
 *    You should have received a copy of the GNU General    *
 *    Public License along with this program.  If not, see  *
 *    <http://www.gnu.org/licenses/>.                       *
 ************************************************************/
#ifndef __MAPPER_SNF_TO_LTL_H__
#define __MAPPER_SNF_TO_LTL_H__

#include <list>
#include <map>
#include <set>
#include "builder_ltl/formula.h"
#include "getopt/options.h"
#include "clause_handle.h"
#include "semi_linear_set.h"
#include "unsat_core_private.h"

namespace UnsatCore
{
  class MapperSnfToLtl
  {
  public:
    static void computeCoreLtl(ClauseHandleSet const & coreStartingClausehs,
                               std::list<TreeNode*> & formulaList,
                               std::map<TreeNode*, ClauseHandleSet> &
                               mapSubformulaToClausehsNow,
                               std::map<TreeNode*, ClauseHandleSet> &
                               mapSubformulaToClausehsNext,
                               std::map<TreeNode*, ClauseHandleSet> &
                               mapSubformulaToClausehsSometime,
                               std::map<ClauseHandle, SemiLinearSet> &
                               mapClausehToSemiLinearSet,
                               std::map<TreeNode*, SemiLinearSet> &
                               mapSubformulaToSemiLinearSet,
                               TRPPPOptions const & options);
    static void simplifyCoreLtl(std::list<TreeNode*> & formulaList,
                                std::set<TreeNode*> & coreSimplifiedSubformulas,
                                TRPPPOptions const & options);
  private:
    static TreeNode * compute_core_simple_ltl_rec(TreeNode * n,
                                                  bool isPositivePolarity,
                                   ClauseHandleSet const & coreStartingClausehs,
                                          std::map<TreeNode*, ClauseHandleSet> &
                                                  mapSubformulaToClausehsNow,
                                          std::map<TreeNode*, ClauseHandleSet> &
                                                  mapSubformulaToClausehsNext,
                                          std::map<TreeNode*, ClauseHandleSet> &
                                                mapSubformulaToClausehsSometime,
                                std::set<TreeNode*> & coreSimplifiedSubformulas,
                                                  TRPPPOptions const & options);
    static TreeNode * compute_core_sets_of_time_points_ltl_rec(TreeNode * n,
                                                        bool isPositivePolarity,
                                   ClauseHandleSet const & coreStartingClausehs,
                                          std::map<TreeNode*, ClauseHandleSet> &
                                                     mapSubformulaToClausehsNow,
                                          std::map<TreeNode*, ClauseHandleSet> &
                                                    mapSubformulaToClausehsNext,
                                          std::map<TreeNode*, ClauseHandleSet> &
                                                mapSubformulaToClausehsSometime,
                                         std::map<ClauseHandle, SemiLinearSet> &
                                                      mapClausehToSemiLinearSet,
                                            std::map<TreeNode*, SemiLinearSet> &
                                                   mapSubformulaToSemiLinearSet,
                                std::set<TreeNode*> & coreSimplifiedSubformulas,
                                                  TRPPPOptions const & options);
    static TreeNode * simplify_core_ltl_rec(TreeNode * n, bool
                                            isPositivePolarity,
                               std::set<TreeNode*> & coreSimplifiedSubformulas);
    static void erase_tn_from_set_rec(TreeNode * n, std::set<TreeNode*> & s);
  }; // class MapperSnfToLtl
} // namespace UnsatCore
#endif // __MAPPER_SNF_TO_LTL_H__
