/**************************************************************/
/* ********************************************************** */
/* *                                                        * */
/* *  Copyright (C) 2001-2011                               * */
/* *  Boris Konev                                           * */
/* *  The University of Liverpool                           * */
/* *                                                        * */
/* *  Copyright (C) 2012-2013                               * */
/* *  Viktor Schuppan                                       * */
/* *                                                        * */
/* *  This program is free software; you can redistribute   * */
/* *  it and/or modify it under the terms of the GNU        * */
/* *  General Public License as published by the Free       * */
/* *  Software Foundation; either version 2 of the License, * */
/* *  or (at your option) any later version.                * */
/* *                                                        * */
/* *  This program is distributed in the hope that it will  * */
/* *  be useful, but WITHOUT ANY WARRANTY; without even     * */
/* *  the implied warranty of MERCHANTABILITY or FITNESS    * */
/* *  FOR A PARTICULAR PURPOSE.  See the GNU General Public * */
/* *  License for more details.                             * */
/* *                                                        * */
/* *  You should have received a copy of the GNU General    * */
/* *  Public License along with this program; if not, write * */
/* *  to the Free Software Foundation, Inc., 59 Temple      * */
/* *  Place, Suite 330, Boston, MA  02111-1307  USA         * */
/* *                                                        * */
/* *                                                        * */
/* ********************************************************** */
/**************************************************************/
#include <iostream>
#include <iomanip>
#include "adaptor/stl_tim_adaptor.h"
#include "misc/timer.h"  
#include "getopt/options.h"
#include "modules.h"
#include "misc/tracer.h"
#include "misc/exception.h"
#include "main_aux.h"
#include "trim/trim.h"

/*
#ifdef DEBUG
#define BOOST_INCLUDE_MAIN 
#include <boost/test/test_tools.hpp>
#endif // DEBUG
*/

using std::cout;

// I use this function instead of main since I emply boost's mechanism
// to catch "uncought" exceptions. If something bad happens, and I do
// not catch this, hopefully, boost will do. This usually gives more
// information than just "segmentation fault" of "abort"

//#ifdef DEBUG
//int test_main(int argc, char **argv)
//#else
int main(int argc, char **argv)
//#endif
{
    Timer timer;

    extern int trp_yydebug;
    trp_yydebug = 0;

    // Initiating data structures
    // (The reason for this operator is that TRIM<> provides 
    //  with some static functions that might be used befoure
    //  any clause set is constructed (e.g. to construct such a set),
    //  and these function relay on some (static) data structures)
    //
    TRIMs::TRIM<Adaptors::Adaptor>::InitiateStatic();

    TRPPPOptions * cmdOptions = NULL;

    try 
    {
        // parse command line options
        cmdOptions = new TRPPPOptions(argc, argv);

        MainAux mainAux(*cmdOptions);

        timer.start();
        mainAux.main();
        timer.stop();

        if(!cmdOptions->isQuiet())
        {
            std::cout << "Elapsed time " << std::fixed << std::setprecision(3) << timer.elapsedSeconds() << "s" << std::endl;
        }

        cmdOptions->cleanup();
        delete(cmdOptions);
        clearTracing();

        return 0;
    }
    catch(const char * ex)
    {
        std::cerr << ex << std::endl;
        exit(1);
    }
    catch (const std::string& s) 
    {
        std::cerr << s << std::endl;
        exit(1);
    }
    catch (Exceptions::EmptyClauseInInput &e)
    {
        std::cout << "Input formula is or has been simplified to False."
                  << std::endl;
        std::cout << ("Unsatisfiable") << std::endl;     
        std::cout << ("Empty clause in the input") << std::endl;     
        cmdOptions->cleanup();
        delete(cmdOptions);
        clearTracing();
        return 0;
    }
    catch (Exceptions::Exception &e)
    {
        std::cout << e.module() << ": " << e.what() << '\n';
        exit(1);
    }
    // basically, we never reach this point, 
    // put here in order to switch off warnings
    return 0;
}
