/************************************************************
 *    Copyright (C) 2014                                    *
 *    Viktor Schuppan (Viktor.Schuppan@gmx.de)              *
 *                                                          *
 *    This program is free software; you can redistribute   *
 *    it and/or modify it under the terms of the GNU        *
 *    General Public License as published by the Free       *
 *    Software Foundation, either version 3 of the License, *
 *    or (at your option) any later version.                *
 *                                                          *
 *    This program is distributed in the hope that it will  *
 *    be useful, but WITHOUT ANY WARRANTY; without even     *
 *    the implied warranty of MERCHANTABILITY or FITNESS    *
 *    FOR A PARTICULAR PURPOSE.  See the GNU General Public *
 *    License for more details.                             *
 *                                                          *
 *    You should have received a copy of the GNU General    *
 *    Public License along with this program.  If not, see  *
 *    <http://www.gnu.org/licenses/>.                       *
 ************************************************************/
#ifndef __LCHO_PARTITION_H__
#define __LCHO_PARTITION_H__

#include <iostream>
#include <set>
#include "unsat_core_private.h"

namespace UnsatCore
{
  class LCHOPartition
  {
  private:
    static unsigned long nextId;
    static Proposition const invalidP;
    unsigned long myId; // unique id of partition
    Proposition myP;
  public:
    LCHOPartition();
    LCHOPartition(Proposition const & p);
    Proposition getP() const;
    std::ostream & dump(std::ostream & os) const;
    bool operator<(LCHOPartition const & other) const;
    bool operator==(LCHOPartition const & other) const;
    bool operator!=(LCHOPartition const & other) const;
  }; // class LCHOPartition

  typedef std::set<LCHOPartition> LCHOPartitionSet;
} // namespace UnsatCore
#endif // __LCHO_PARTITION_H__
